/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.message;

import android.support.annotation.Nullable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.style.StyleSpan;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.antlr.TextBlockLexer;
import com.zoyi.channel.plugin.android.antlr.TextBlockParser;
import com.zoyi.channel.plugin.android.antlr.TextBlockParserBaseListener;
import com.zoyi.channel.plugin.android.enumerate.LinkType;
import com.zoyi.channel.plugin.android.model.etc.BlockParseResult;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.store.UserStore;
import com.zoyi.channel.plugin.android.util.AssetUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.util.message.LinkSpan;
import com.zoyi.channel.plugin.android.util.message.MessageParseOptions;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.org.antlr.v4.runtime.CharStreams;
import com.zoyi.org.antlr.v4.runtime.CommonTokenStream;
import com.zoyi.org.antlr.v4.runtime.RuleContext;
import com.zoyi.org.antlr.v4.runtime.tree.ParseTree;
import com.zoyi.org.antlr.v4.runtime.tree.ParseTreeListener;
import com.zoyi.org.antlr.v4.runtime.tree.ParseTreeWalker;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class MessageParser
extends TextBlockParserBaseListener {
    private String currentAttrName;
    private boolean stateLink;
    private boolean stateAttrValue;
    private StringBuilder linkTextBuilder;
    private StringBuilder attrValueBuilder;
    private StringBuilder variableFallbackTextBuilder;
    private StringBuilder contentBuilder;
    private SpannableStringBuilder spannableStringBuilder;
    private boolean hasOnlyEmoji = true;
    private ParseTreeWalker walker;
    private int boldCount;
    private int italicCount;
    private Stack<Tag> tags = new Stack();
    private MessageParseOptions options;
    @Nullable
    private Marketing marketing;

    public MessageParser(MessageParseOptions options) {
        this(options, null);
    }

    public MessageParser(MessageParseOptions options, @Nullable Marketing marketing) {
        this.walker = new ParseTreeWalker();
        this.spannableStringBuilder = new SpannableStringBuilder();
        this.linkTextBuilder = new StringBuilder();
        this.attrValueBuilder = new StringBuilder();
        this.variableFallbackTextBuilder = new StringBuilder();
        this.contentBuilder = new StringBuilder();
        this.options = options;
        this.marketing = marketing;
    }

    public BlockParseResult parse(String text) {
        this.tags.clear();
        this.boldCount = 0;
        this.italicCount = 0;
        this.stateLink = false;
        this.linkTextBuilder.setLength(0);
        this.attrValueBuilder.setLength(0);
        this.variableFallbackTextBuilder.setLength(0);
        TextBlockParser parser = (TextBlockParser)((Object)Optional.of((Object)text).map(CharStreams::fromString).map(TextBlockLexer::new).map(CommonTokenStream::new).map(TextBlockParser::new).get());
        parser.setBuildParseTree(true);
        this.walker.walk((ParseTreeListener)this, (ParseTree)parser.block());
        return new BlockParseResult(this.spannableStringBuilder, this.hasOnlyEmoji);
    }

    @Override
    public void enterTag(TextBlockParser.TagContext ctx) {
        String tagName = (String)Optional.ofNullable((Object)((Object)ctx)).map(c -> c.TAG_NAME(0)).map(ParseTree::getText).orElse(null);
        if (tagName != null) {
            this.tags.push(new Tag(tagName));
            switch (tagName) {
                case "b": {
                    ++this.boldCount;
                    break;
                }
                case "i": {
                    ++this.italicCount;
                    break;
                }
                case "link": {
                    this.stateLink = true;
                }
            }
        } else {
            this.tags.push(null);
        }
        this.hasOnlyEmoji = false;
    }

    @Override
    public void exitTag(TextBlockParser.TagContext ctx) {
        Tag tag = this.tags.pop();
        if (tag != null && tag.getName() != null) {
            switch (tag.getName()) {
                case "b": {
                    --this.boldCount;
                    break;
                }
                case "i": {
                    --this.italicCount;
                    break;
                }
                case "link": {
                    this.parseLink(tag);
                }
            }
        }
        this.hasOnlyEmoji = false;
    }

    @Override
    public void enterAttribute(TextBlockParser.AttributeContext ctx) {
        Optional.ofNullable((Object)((Object)ctx)).map(TextBlockParser.AttributeContext::TAG_NAME).map(ParseTree::getText).ifPresent(tagName -> {
            this.currentAttrName = tagName;
        });
    }

    @Override
    public void exitAttribute(TextBlockParser.AttributeContext ctx) {
        Optional.ofNullable((Object)this.tags.peek()).ifPresent(top -> ((Tag)top).getAttributes().put(this.currentAttrName, this.attrValueBuilder.toString()));
        this.hasOnlyEmoji = false;
    }

    @Override
    public void enterAttrValue(TextBlockParser.AttrValueContext ctx) {
        this.stateAttrValue = true;
        this.attrValueBuilder.setLength(0);
    }

    @Override
    public void exitAttrValue(TextBlockParser.AttrValueContext ctx) {
        this.stateAttrValue = false;
        this.attrValueBuilder.append(this.replaceAllEscape(ctx.getText()));
    }

    @Override
    public void exitContent(TextBlockParser.ContentContext ctx) {
        if (!this.stateLink) {
            this.spannableStringBuilder.append((CharSequence)this.getTextSpan(this.contentBuilder.toString()));
            this.contentBuilder.setLength(0);
        }
    }

    @Override
    public void exitEmoji(TextBlockParser.EmojiContext ctx) {
        String text = (String)Optional.ofNullable((Object)AssetUtils.getEmoji(ChannelIO.getAppContext(), ctx.EMOJI().getText().replaceAll(":", ""))).orElse((Object)ctx.EMOJI().getText());
        if (this.stateLink) {
            this.linkTextBuilder.append(text);
        } else {
            this.contentBuilder.append(text);
        }
    }

    @Override
    public void exitVariable(TextBlockParser.VariableContext ctx) {
        if (this.options.isVariableEnabled()) {
            String key = (String)Optional.ofNullable((Object)ctx.VAR_NAME()).map(ParseTree::getText).orElse((Object)"");
            String fallback = (String)Optional.ofNullable((Object)((Object)ctx.variableFallback())).map(RuleContext::getText).orElse((Object)String.format("${%s}", key));
            this.parseText((String)Optional.ofNullable((Object)UserStore.get().user.get()).map(u -> u.getProfileValue(key)).map(Object::toString).orElse((Object)fallback));
        } else {
            Optional.ofNullable((Object)ctx.getText()).ifPresent(this::parseText);
        }
        this.hasOnlyEmoji = false;
    }

    @Override
    public void exitPlain(TextBlockParser.PlainContext ctx) {
        this.parseText(ctx.getText());
        if (!this.isAllowedForGiantEmoji(ctx.getText())) {
            this.hasOnlyEmoji = false;
        }
    }

    @Override
    public void exitEscape(TextBlockParser.EscapeContext ctx) {
        if (!this.stateAttrValue) {
            Optional.ofNullable((Object)((Object)ctx)).map(RuleContext::getText).ifPresent(text -> this.parseText(this.replaceEscape((String)text)));
            this.hasOnlyEmoji = false;
        }
    }

    private void parseText(String text) {
        if (this.stateAttrValue) {
            this.attrValueBuilder.append(text);
            return;
        }
        if (this.stateLink) {
            this.linkTextBuilder.append(text);
            return;
        }
        this.contentBuilder.append(text);
    }

    private void parseLink(Tag tag) {
        String inlineText = this.linkTextBuilder.toString();
        Optional.ofNullable((Object)tag.get("type")).ifPresent(type -> {
            switch (type) {
                case "url": {
                    if (tag.get("value") != null) {
                        this.spannableStringBuilder.append((CharSequence)this.getLinkSpannableString(inlineText, tag.get("value")));
                        break;
                    }
                    this.spannableStringBuilder.append((CharSequence)this.getURLSpannableString(inlineText));
                    break;
                }
                case "email": {
                    this.spannableStringBuilder.append((CharSequence)this.getEmailSpan(inlineText));
                    break;
                }
                case "manager": {
                    this.spannableStringBuilder.append((CharSequence)inlineText);
                }
            }
        });
        this.linkTextBuilder.setLength(0);
        this.stateLink = false;
    }

    private void applySpan(SpannableString spannableString, Object span) {
        spannableString.setSpan(span, 0, spannableString.length(), 33);
    }

    private void applyStyleSpan(SpannableString spannableString) {
        if (this.boldCount > 0 && this.italicCount > 0) {
            this.applySpan(spannableString, new StyleSpan(3));
        } else if (this.boldCount > 0) {
            this.applySpan(spannableString, new StyleSpan(1));
        } else if (this.italicCount > 0) {
            this.applySpan(spannableString, new StyleSpan(2));
        }
    }

    private SpannableString getTextSpan(String text) {
        SpannableString spannableString = new SpannableString((CharSequence)text);
        this.applyStyleSpan(spannableString);
        return spannableString;
    }

    private SpannableString getLinkSpannableString(String text, String targetUrl) {
        SpannableString spannableString = new SpannableString((CharSequence)text);
        LinkSpan span = new LinkSpan(targetUrl, LinkType.URL, this.marketing);
        this.applyStyleSpan(spannableString);
        this.applySpan(spannableString, (Object)span);
        return spannableString;
    }

    private SpannableString getURLSpannableString(String url) {
        return this.getLinkSpannableString(url, url);
    }

    private SpannableString getEmailSpan(String email) {
        SpannableString spannableString = new SpannableString((CharSequence)email);
        LinkSpan span = new LinkSpan(email, LinkType.EMAIL, this.marketing);
        this.applyStyleSpan(spannableString);
        this.applySpan(spannableString, (Object)span);
        return spannableString;
    }

    private boolean isAllowedForGiantEmoji(@Nullable String text) {
        if (text == null) {
            return true;
        }
        return StringUtils.stripEnd(text, "\n").isEmpty();
    }

    @Nullable
    private String replaceEscape(String text) {
        String resultText = text == null ? "" : text;
        switch (text) {
            case "&amp;": {
                resultText = "&";
                break;
            }
            case "&lt;": {
                resultText = "<";
                break;
            }
            case "&gt;": {
                resultText = ">";
                break;
            }
            case "&quot;": {
                resultText = "\"";
                break;
            }
            case "&dollar;": {
                resultText = "$";
            }
        }
        return resultText;
    }

    private String replaceAllEscape(String text) {
        return (text == null ? "" : text).replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&dollar;", "$");
    }

    public class Tag {
        private String name;
        private Map<String, String> attributes;

        public Tag(String name) {
            this.name = name;
            this.attributes = new HashMap<String, String>();
        }

        public String getName() {
            return this.name;
        }

        private Map<String, String> getAttributes() {
            return this.attributes;
        }

        private String get(String key) {
            return this.attributes.get(key);
        }
    }
}

