/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.net.Uri;
import com.zoyi.com.google.android.exoplayer2.DefaultRenderersFactory;
import com.zoyi.com.google.android.exoplayer2.ExoPlayerFactory;
import com.zoyi.com.google.android.exoplayer2.RenderersFactory;
import com.zoyi.com.google.android.exoplayer2.SimpleExoPlayer;
import com.zoyi.com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.zoyi.com.google.android.exoplayer2.source.MediaSource;
import com.zoyi.com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelector;
import com.zoyi.com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.zoyi.com.google.android.exoplayer2.upstream.DataSource;
import com.zoyi.com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.zoyi.com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.zoyi.com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.List;

public class ExoPlayerManager {
    private static ExoPlayerManager exoPlayerManager;
    private SimpleExoPlayer player;
    private List<Playable> playables;

    public static ExoPlayerManager getInstance(Context context, Playable playable) {
        if (exoPlayerManager == null) {
            exoPlayerManager = new ExoPlayerManager(context);
        }
        exoPlayerManager.addPlayable(playable);
        return exoPlayerManager;
    }

    private ExoPlayerManager(Context context) {
        DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)bandwidthMeter);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        this.player = ExoPlayerFactory.newSimpleInstance((Context)context, (RenderersFactory)new DefaultRenderersFactory(context), (TrackSelector)trackSelector);
        this.playables = new ArrayList<Playable>();
    }

    public SimpleExoPlayer playVideo(Context context, String url, Playable currentPlayable, long lastPosition) {
        for (Playable playable : this.playables) {
            if (playable == null || playable == currentPlayable) continue;
            playable.onStop();
        }
        this.stopVideo();
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(context, Util.getUserAgent((Context)context, (String)"ChannelTalkSDK"));
        ExtractorMediaSource videoSource = new ExtractorMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(Uri.parse((String)url));
        this.player.prepare((MediaSource)videoSource);
        this.player.seekTo(lastPosition);
        this.player.setPlayWhenReady(true);
        currentPlayable.onPlay();
        return this.player;
    }

    private void stopVideo() {
        this.player.setPlayWhenReady(false);
    }

    public void stopVideo(Playable playable) {
        playable.onStop();
        this.removePlayable(playable);
        this.stopVideo();
    }

    private void addPlayable(Playable playable) {
        if (!this.playables.contains(playable)) {
            this.playables.add(playable);
        }
    }

    public void removePlayable(Playable playable) {
        this.playables.remove(playable);
    }

    public static interface Playable {
        public void onPlay();

        public void onStop();
    }
}

