/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chats;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatUtils;
import com.zoyi.channel.plugin.android.activity.chats.ChatsAdapter;
import com.zoyi.channel.plugin.android.activity.chats.ChatsPresenter;
import com.zoyi.channel.plugin.android.activity.chats.contract.ChatsContract;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.scrollview.RecyclerBottomPlaceholderLayout;

public class ChatsActivity
extends BaseActivity2
implements ChatsContract.View,
OnChatClickListener {
    private NavigationView navigation;
    private View layoutChats;
    private View progressChats;
    private View viewChatsError;
    private RecyclerView recyclerViewChats;
    private View viewChatsEmpty;
    private RecyclerBottomPlaceholderLayout bottomLayoutChats;
    private ChatStartButton startButton;
    private ChatsAdapter adapter;
    private ChatsContract.Presenter presenter;
    private LinearLayoutManager layoutManager;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_chats);
        this.navigation = (NavigationView)this.findViewById(R.id.ch_navigationChats);
        this.navigation.addAction(R.drawable.ch_plugin_close_white, v -> Action.invoke(ActionType.EXIT));
        this.layoutChats = this.findViewById(R.id.ch_layoutChats);
        this.viewChatsError = this.findViewById(R.id.ch_layoutErrorRefreshChats);
        this.adapter = new ChatsAdapter();
        this.adapter.setListener(this);
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.recyclerViewChats = (RecyclerView)this.findViewById(R.id.ch_recyclerViewChats);
        this.recyclerViewChats.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerViewChats.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerViewChats.setItemAnimator(null);
        this.recyclerViewChats.getRecycledViewPool().setMaxRecycledViews(0, 40);
        this.recyclerViewChats.addOnScrollListener((RecyclerView.OnScrollListener)new InfiniteScrollListener(){

            @Override
            public void scrollAttachedToBottom() {
                ChatsActivity.this.presenter.fetchUserChatNext();
            }

            @Override
            public void scrollAttachedToTop() {
            }
        });
        this.startButton = (ChatStartButton)this.findViewById(R.id.ch_buttonChatsStartNewChat);
        this.startButton.setOnClickListener(v -> this.startNewChat());
        this.progressChats = this.findViewById(R.id.ch_progressChats);
        this.viewChatsEmpty = this.findViewById(R.id.ch_layoutChatsEmpty);
        this.bottomLayoutChats = (RecyclerBottomPlaceholderLayout)this.findViewById(R.id.ch_bottomLayoutChats);
        this.bottomLayoutChats.setRecyclerView(this.recyclerViewChats);
        this.presenter = new ChatsPresenter(this, this.adapter, this.adapter);
        this.bindPresenter(this.presenter);
        return true;
    }

    @Override
    public void onChatsCountChange(int count) {
        if (count > 0) {
            this.recyclerViewChats.setVisibility(0);
            this.viewChatsEmpty.setVisibility(8);
        } else {
            this.recyclerViewChats.setVisibility(8);
            this.viewChatsEmpty.setVisibility(0);
        }
    }

    @Override
    public void onUserChatsFetchStateChange(FetchState fetchState) {
        this.viewChatsError.setVisibility(8);
        switch (fetchState) {
            case FAILED: {
                this.layoutChats.setVisibility(8);
                this.viewChatsError.setVisibility(0);
                break;
            }
            case COMPLETE: {
                this.progressChats.setVisibility(8);
                this.layoutChats.setVisibility(0);
            }
        }
    }

    @Override
    public void onChatItemClick(@NonNull ChatItem chatItem) {
        ChatUtils.createChatActivityIntent((Activity)this).putExtra("chatContentType", chatItem.getType().toString()).putExtra("chatContentId", chatItem.getSubKey()).startActivityForResult(21);
    }

    private void startNewChat() {
        ChatUtils.createChatActivityIntent((Activity)this).startActivityForResult(21);
    }

    @Override
    public void onChatItemLongClick(@NonNull ChatItem chatItem) {
        ((ChannelDialog)((Object)((ChannelDialog)((Object)((ChannelDialog)((Object)new ChannelDialog((Context)this).setDescription(ResUtils.getString("ch.chat.delete_description")).addButton(ButtonType.CANCEL))).addButton(ButtonType.OK, v -> this.presenter.removeChat(chatItem)))).allowBackpress(true))).show();
    }

    @Override
    public boolean isOnTop() {
        return !this.recyclerViewChats.canScrollVertically(-1);
    }

    @Override
    public void scrollToTop() {
        this.layoutManager.scrollToPosition(0);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 21 && resultCode == 22) {
            ChatUtils.createChatActivityIntent((Activity)this).setTransition(Transition.NONE).startActivityForResult(21);
        }
    }
}

