/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.Button;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.selector.SettingsSelector;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.rx.functions.Action1;

public class WatchedEditText
extends AppCompatEditText {
    private Context context;
    @Nullable
    private Button button;
    @Nullable
    private EditTextChangedListener listener;
    @Nullable
    private String hintTextKey;
    private boolean block = false;
    private int activeColor;
    private int deactiveColor;
    @Nullable
    private Binder binder;

    public WatchedEditText(Context context) {
        super(context);
        this.init(context, null);
    }

    public WatchedEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public WatchedEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.context = context;
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ChannelCustomView);
            try {
                this.hintTextKey = typedArray.getString(R.styleable.ChannelCustomView_ch_text_hint_key);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.binder = SettingsSelector.bindLanguage((Action1<Language>)((Action1)language -> {
                if (this.context != null && this.hintTextKey != null) {
                    this.setHint(ResUtils.getString(this.context, this.hintTextKey));
                }
            }));
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.binder != null) {
            this.binder.unbind();
        }
    }

    public void setWatchedTextChangedListener(@Nullable EditTextChangedListener listener) {
        this.listener = listener;
        if (listener != null) {
            listener.onWatchedTextChanged(this.getString());
        }
    }

    protected void onSelectionChanged(int start, int end) {
        super.onSelectionChanged(start, end);
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        if (this.listener != null && !this.block) {
            this.listener.onWatchedTextChanged(text.toString());
        }
        this.setButtonStyle(text.toString());
    }

    private void setButtonStyle(String text) {
        if (this.button != null) {
            if ("".equals(StringUtils.stripEnd(text, null))) {
                this.button.setEnabled(false);
                this.button.setTextColor(this.deactiveColor);
            } else {
                this.button.setEnabled(true);
                this.button.setTextColor(this.activeColor);
            }
        }
    }

    public void setTextWithBlock(String text) {
        this.block = true;
        this.setText(text);
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public String getString() {
        Editable editable = this.getText();
        if (editable != null) {
            return editable.toString();
        }
        return "";
    }

    public boolean isEmpty() {
        return TextUtils.isEmpty((CharSequence)this.getString());
    }
}

