package com.zoyi.channel.plugin.android.activity.lounge;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.common.userchat.callback.ChatListCallback;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.viewholder.ChatHolder;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeAdapterContract;
import com.zoyi.channel.plugin.android.global.Const;

import java.util.List;

public class LoungeAdapter extends RecyclerView.Adapter<ChatHolder> implements LoungeAdapterContract.View, LoungeAdapterContract.Model {

  @NonNull
  private SortedList<ChatItem> items;

  @Nullable
  private OnChatClickListener listener;

  public LoungeAdapter() {
    this.items = new SortedList<>(ChatItem.class, new ChatListCallback(this));
  }

  public void setListener(@Nullable OnChatClickListener listener) {
    this.listener = listener;
  }

  @Override
  public void updateChatItems(List<ChatItem> items) {
    this.items.replaceAll(items);
  }

  @NonNull
  @Override
  public ChatHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
    return ChatHolder.newInstance(parent, listener);
  }

  @Override
  public void onBindViewHolder(@NonNull ChatHolder holder, int position) {
    holder.bind(items.get(position));
  }

  @Override
  public int getItemCount() {
    return Math.min(this.items.size(), Const.LOUNGE_PREVIEW_MAX_CHATS);
  }
}
