/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.annimon.stream.function;

import com.zoyi.com.annimon.stream.function.ThrowableLongPredicate;

public interface LongPredicate {
    public boolean test(long var1);

    public static class Util {
        private Util() {
        }

        public static LongPredicate and(final LongPredicate p1, final LongPredicate p2) {
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return p1.test(value) && p2.test(value);
                }
            };
        }

        public static LongPredicate or(final LongPredicate p1, final LongPredicate p2) {
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return p1.test(value) || p2.test(value);
                }
            };
        }

        public static LongPredicate xor(final LongPredicate p1, final LongPredicate p2) {
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return p1.test(value) ^ p2.test(value);
                }
            };
        }

        public static LongPredicate negate(final LongPredicate p1) {
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    return !p1.test(value);
                }
            };
        }

        public static LongPredicate safe(ThrowableLongPredicate<Throwable> throwablePredicate) {
            return Util.safe(throwablePredicate, false);
        }

        public static LongPredicate safe(final ThrowableLongPredicate<Throwable> throwablePredicate, final boolean resultIfFailed) {
            return new LongPredicate(){

                @Override
                public boolean test(long value) {
                    try {
                        return throwablePredicate.test(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

