package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.Button;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.selector.SettingsSelector;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;

/**
 * Created by mika on 2016. 3. 9..
 */
public class WatchedEditText extends AppCompatEditText {

  private Context context;

  @Nullable
  private Button button;
  @Nullable
  private EditTextChangedListener listener;

  @Nullable
  private String hintTextKey;

  private boolean block = false;
  private int activeColor, deactiveColor;

  @Nullable
  private Binder binder;

  public WatchedEditText(Context context) {
    super(context);
    init(context, null);
  }

  public WatchedEditText(Context context, AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public WatchedEditText(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @Initializer
  private void init(Context context, @Nullable AttributeSet attrs) {
    this.context = context;

    if (attrs != null) {
      TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ChannelCustomView);
      try {
        hintTextKey = typedArray.getString(R.styleable.ChannelCustomView_ch_text_hint_key);
      } finally {
        typedArray.recycle();
      }
    }
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    if (!isInEditMode()) {
      binder = SettingsSelector.bindLanguage(language -> {
        if (context != null && hintTextKey != null) {
          setHint(ResUtils.getString(context, hintTextKey));
        }
      });
    }
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (binder != null) {
      binder.unbind();
    }
  }

  public void setWatchedTextChangedListener(@Nullable EditTextChangedListener listener) {
    this.listener = listener;

    if (listener != null) {
      listener.onWatchedTextChanged(getString());
    }
  }

  @Override
  protected void onSelectionChanged(int start, int end) {
    super.onSelectionChanged(start, end);
  }

  @Override
  protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
    super.onTextChanged(text, start, lengthBefore, lengthAfter);
    if (listener != null && !block) {
      listener.onWatchedTextChanged(text.toString());
    }
    setButtonStyle(text.toString());
  }

  private void setButtonStyle(String text) {
    if (button != null) {
      if ("".equals(StringUtils.stripEnd(text, null))) {
        button.setEnabled(false);
        button.setTextColor(deactiveColor);
      } else {
        button.setEnabled(true);
        button.setTextColor(activeColor);
      }
    }
  }

  public void setTextWithBlock(String text) {
    this.block = true;
    setText(text);
  }

  public void setBlock(boolean block) {
    this.block = block;
  }

  public String getString() {
    Editable editable = getText();
    if (editable != null) {
      return editable.toString();
    }
    return "";
  }

  public boolean isEmpty() {
    return TextUtils.isEmpty(getString());
  }
}
