/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.io;

import com.splunk.mint.network.Counter;
import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.NetLogManager;
import com.splunk.mint.network.socket.MonitoringSocketImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class InputStreamMonitorKitKat
extends InputStream {
    private static final String IN_POSTFIX = "-bytes-in";
    private final InputStream original;
    private final Counter counter;
    private List<Byte> chars;
    private StringBuffer body;
    private boolean finishedReadingHeaders = false;
    public String exception = null;
    MonitoringSocketImpl monSocIm;
    private static final int MAX_POSSIBLE_HEADER_LENGTH = 50;
    boolean statusCodeFound = false;
    boolean contentLengthFound = false;
    HashMap<String, List<String>> headers = new HashMap(2);

    public InputStreamMonitorKitKat(String name, MonitorRegistry registry, InputStream original, MonitoringSocketImpl monSocIm) {
        this.original = original;
        this.counter = new Counter(name + IN_POSTFIX);
        this.chars = new ArrayList<Byte>();
        this.body = new StringBuffer();
        this.monSocIm = monSocIm;
        this.finishedReadingHeaders = false;
        registry.add(this.counter);
    }

    @Override
    public int read() throws IOException {
        try {
            int value = this.original.read();
            if (value > -1) {
                this.counter.inc();
            }
            if (!this.finishedReadingHeaders) {
                this.chars.add((byte)value);
                this.updateBody();
            }
            return value;
        }
        catch (IOException e) {
            this.exception = NetLogManager.exceptionToString(e);
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        try {
            int value = this.original.read(buffer);
            if (value > -1) {
                this.counter.inc(value);
            }
            if (!this.finishedReadingHeaders) {
                for (int i = 0; i < buffer.length; ++i) {
                    this.chars.add(buffer[i]);
                }
                this.updateBody();
            }
            return value;
        }
        catch (IOException e) {
            this.exception = NetLogManager.exceptionToString(e);
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        try {
            int value = this.original.read(buffer, byteOffset, byteCount);
            if (value > -1) {
                this.counter.inc(value);
            }
            if (!this.finishedReadingHeaders) {
                for (int i = byteOffset; i < byteCount; ++i) {
                    this.chars.add(buffer[i]);
                }
                this.updateBody();
            }
            return value;
        }
        catch (IOException e) {
            this.exception = NetLogManager.exceptionToString(e);
            throw e;
        }
    }

    private void updateBody() {
        byte[] data = new byte[this.chars.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.chars.get(i);
        }
        this.chars.clear();
        this.body.append(new String(data));
        if (this.body.toString().contains("\r\n\r\n")) {
            this.finishedReadingHeaders = true;
            this.tryToReadHeaders();
        }
    }

    public void tryToReadHeaders() {
        BufferedReader in = new BufferedReader(new StringReader(this.body.toString()));
        String line = null;
        try {
            while ((line = in.readLine()) != null) {
                String name;
                int start;
                if (!this.statusCodeFound && line.contains("HTTP/") && line.length() < 50) {
                    try {
                        String[] parts = line.split(" ");
                        String[] array = new String[]{parts[1].trim()};
                        this.headers.put("splk-statuscode", Arrays.asList(array));
                        this.statusCodeFound = true;
                    }
                    catch (ArrayIndexOutOfBoundsException parts) {
                        // empty catch block
                    }
                }
                if (!this.contentLengthFound && line.contains(":") && line.length() < 50 && (start = line.indexOf(":")) > -1 && (name = line.substring(0, start).trim()).equals("Content-Length")) {
                    try {
                        String[] array = new String[]{line.substring(start + 1, line.length()).trim()};
                        this.headers.put(name, Arrays.asList(array));
                        this.contentLengthFound = true;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                if (!this.statusCodeFound || !this.contentLengthFound) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.monSocIm != null) {
            this.monSocIm.readingDone();
        }
    }

    @Override
    public void close() throws IOException {
        this.original.close();
    }

    public HashMap<String, List<String>> getHeaders() {
        return this.headers;
    }
}

