package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.zoyi.com.google.i18n.phonenumbers.Phonenumber;

import java.math.BigDecimal;
import java.util.Locale;

public class FormatUtils {

  @Nullable
  public static String formatDuration(@Nullable Long durationMilliseconds) {
    if (durationMilliseconds == null || durationMilliseconds == 0L) {
      return null;
    }

    long durationSeconds = durationMilliseconds / 1000;
    long hours = durationSeconds / 3600;
    long minutes = (durationSeconds % 3600) / 60;
    long seconds = durationSeconds % 60;

    if (hours > 0) {
      return String.format(Locale.ENGLISH, "%d:%02d:%02d", hours, minutes, seconds);
    }
    return String.format(Locale.ENGLISH, "%d:%02d", minutes, seconds);
  }

  public static String formatFileSize(long bytes) {
    if (bytes < 1000) {
      return String.format(Locale.US, "%dB", bytes);
    } else if (bytes <= 1000000) {
      return String.format(Locale.US, "%.1fKB", bytes / 1000.0);
    } else if (bytes <= 1000000000) {
      return String.format(Locale.US, "%.1fMB", bytes / 1000000.0);
    } else {
      return String.format(Locale.US, "%.1fGB", bytes / 1000000000.0);
    }
  }

  public static String formatUserProfile(String key, String type, @Nullable Object value) {
    if (Const.PROFILE_MOBILE_NUMBER_KEY.equals(key) && value instanceof String) {
      PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
      try {
        Phonenumber.PhoneNumber numberProto = phoneUtil.parse(value.toString(), "");
        return phoneUtil.format(numberProto, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
      } catch (Exception ignored) {
      }
    }

    if (Const.PROFILE_TYPE_DATE.equals(type) && value instanceof Long) {
      String datetimeFormat = TimeUtils.formatDatetime((Long) value);

      if (!TextUtils.isEmpty(datetimeFormat)) {
        return datetimeFormat;
      }
    }

    if (Const.PROFILE_TYPE_BOOLEAN.equals(type) && value instanceof Boolean) {
      if ((boolean) value) {
        return ResUtils.getString("ch.profile_form.boolean.yes");
      } else {
        return ResUtils.getString("ch.profile_form.boolean.no");
      }
    }

    if (value == null) {
      return "";
    } else if (value instanceof Double) {
      BigDecimal bigDecimal = new BigDecimal(value.toString());
      String numberValue = bigDecimal.toString();

      if (numberValue.endsWith(".0")) {
        return numberValue.replace(".0", "");
      } else {
        return numberValue;
      }
    } else {
      return value.toString();
    }
  }
}
