/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.push.ChannelBroadcastReceiver;
import com.zoyi.channel.plugin.android.push.PushData;

public class NotificationFactory {
    @Nullable
    static NotificationCompat.Builder createPushMessage(Context context, PushData pushData) {
        NotificationCompat.Builder builder = NotificationFactory.createBuilder(context, pushData);
        if (builder == null) {
            return null;
        }
        return builder;
    }

    @Nullable
    private static NotificationCompat.Builder createBuilder(Context context, PushData pushData) {
        String message = pushData.getMessage();
        if (TextUtils.isEmpty((CharSequence)message)) {
            return null;
        }
        NotificationCompat.Builder builder = NotificationFactory.initBuilder(context);
        builder.setSmallIcon(R.drawable.ch_push_icon).setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.ch_push_large_icon)).setContentTitle((CharSequence)context.getString(R.string.notification_title)).setContentText((CharSequence)message).setContentIntent(NotificationFactory.getContentIntent(context, pushData)).setAutoCancel(true).setStyle((NotificationCompat.Style)NotificationFactory.getBigTextStyle(message)).setDefaults(-1);
        if (Build.VERSION.SDK_INT >= 21) {
            builder.setCategory("msg").setPriority(1).setVisibility(1);
        }
        return builder;
    }

    private static NotificationCompat.Builder initBuilder(Context context) {
        NotificationManager notificationManager;
        if (Build.VERSION.SDK_INT >= 26 && NotificationFactory.isOreoSupportLibrary() && (notificationManager = (NotificationManager)context.getSystemService("notification")) != null) {
            NotificationChannel channel = new NotificationChannel("ChannelIO", (CharSequence)"ChannelIO", 4);
            notificationManager.createNotificationChannel(channel);
            return new NotificationCompat.Builder(context, channel.getId());
        }
        return new NotificationCompat.Builder(context);
    }

    private static boolean isOreoSupportLibrary() {
        try {
            NotificationCompat.Builder.class.getConstructor(Context.class, String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static PendingIntent getContentIntent(Context context, PushData pushData) {
        Intent clickIntent = new Intent("com.zoyi.channel.plugin.android.push.CHANNEL_PUSH_CLICK");
        clickIntent.setComponent(new ComponentName(context, ChannelBroadcastReceiver.class));
        clickIntent.putExtra("host_app_intent", (Parcelable)NotificationFactory.getHostAppIntent(context, pushData));
        return PendingIntent.getBroadcast((Context)context, (int)999998, (Intent)clickIntent, (int)0x8000000);
    }

    private static Intent getHostAppIntent(Context context, PushData pushData) {
        Intent hostAppIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (hostAppIntent == null) {
            hostAppIntent = new Intent();
        } else {
            hostAppIntent.addCategory("android.intent.category.LAUNCHER");
            hostAppIntent.putExtra("channelId", pushData.getChannelId());
            hostAppIntent.putExtra("personType", pushData.getPersonType());
            hostAppIntent.putExtra("personId", pushData.getPersonId());
            hostAppIntent.putExtra("chatId", pushData.getChatId());
        }
        hostAppIntent.setFlags(0x10008000);
        return hostAppIntent;
    }

    private static NotificationCompat.BigTextStyle getBigTextStyle(String message) {
        return new NotificationCompat.BigTextStyle().bigText((CharSequence)message);
    }
}

