/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import android.content.pm.PackageManager;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;
import java.io.IOException;

public class UserAgentInterceptor
implements Interceptor {
    @Nullable
    private String hostAppHeader;

    private String getSdkHeader() {
        return String.format("android/%s", "8.0.0-beta3");
    }

    private String getHostAppHeader() {
        if (this.hostAppHeader == null) {
            this.hostAppHeader = (String)Optional.ofNullable((Object)ChannelIO.getAppContext()).map(context -> {
                try {
                    return String.format("%s/%s", context.getPackageName(), context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName);
                }
                catch (PackageManager.NameNotFoundException e) {
                    return null;
                }
            }).orElse(null);
        }
        if (this.hostAppHeader != null) {
            return this.hostAppHeader;
        }
        return "";
    }

    private String getUserAgent() {
        return System.getProperty("http.agent");
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request().newBuilder().header("x-channel-sdk", this.getSdkHeader()).header("x-host-app", this.getHostAppHeader()).header("User-Agent", this.getUserAgent()).build();
        return chain.proceed(request);
    }
}

