/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.rx.functions.Action1;

public class SettingsHeaderView
extends LinearLayout {
    private TextView textChannelName;
    private TextView textChannelUrl;
    private TextView textChannelDescription;
    private AvatarLayout avatarChannel;
    @Nullable
    private Binder channelBinder;
    @Nullable
    private Binder pluginBinder;

    public SettingsHeaderView(Context context) {
        super(context);
        this.init(context);
    }

    public SettingsHeaderView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SettingsHeaderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_settings_header, (ViewGroup)this, true);
        this.textChannelName = (TextView)view.findViewById(R.id.ch_textSettingsChannelName);
        this.textChannelUrl = (TextView)view.findViewById(R.id.ch_textSettingsChannelUrl);
        this.textChannelDescription = (TextView)view.findViewById(R.id.ch_textSettingsChannelDescription);
        this.avatarChannel = (AvatarLayout)view.findViewById(R.id.ch_avatarSettingsChannel);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.channelBinder = ChannelSelector.bindChannel((Action1<Channel>)((Action1)channel -> {
            this.textChannelName.setText((CharSequence)channel.getName());
            this.textChannelUrl.setText((CharSequence)channel.getHomepageUrl());
            this.textChannelUrl.setVisibility(!TextUtils.isEmpty((CharSequence)channel.getHomepageUrl()) ? 0 : 8);
            this.textChannelDescription.setText((CharSequence)channel.getDescription());
            this.textChannelDescription.setVisibility(!TextUtils.isEmpty((CharSequence)channel.getDescription()) ? 0 : 8);
            this.avatarChannel.set((ProfileEntity)channel);
        }));
        this.pluginBinder = PluginSelector.bindPlugin((Action1<Plugin>)((Action1)plugin -> {
            this.textChannelName.setTextColor(plugin.getTextColor());
            this.textChannelUrl.setTextColor(plugin.getTextColor());
            this.textChannelDescription.setTextColor(plugin.getTextColor());
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.channelBinder != null) {
            this.channelBinder.unbind();
            this.channelBinder = null;
        }
        if (this.pluginBinder != null) {
            this.pluginBinder.unbind();
            this.pluginBinder = null;
        }
    }
}

