package com.zoyi.channel.plugin.android.open.model;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.com.google.gson.Gson;

import java.util.HashMap;
import java.util.Map;

public class Profile {

  @Nullable
  private String name;
  @Nullable
  private String email;
  @Nullable
  private String avatarUrl;
  @Nullable
  private String mobileNumber;
  private HashMap<String, Object> property;

  public static Profile create() {
    return new Profile();
  }

  private Profile() {
    property = new HashMap<>();
  }

  @Nullable
  public String getName() {
    return name;
  }

  @Nullable
  public String getEmail() {
    return email;
  }

  @Nullable
  public String getMobileNumber() {
    return mobileNumber;
  }

  @Nullable
  public String getAvatarUrl() {
    return avatarUrl;
  }

  public Map<String, Object> getProperty() {
    return property;
  }

  public Profile setName(@Nullable String name) {
    this.name = name;
    return this;
  }

  public Profile setEmail(@Nullable String email) {
    this.email = email;
    return this;
  }

  public Profile setMobileNumber(@Nullable String mobileNumber) {
    this.mobileNumber = mobileNumber;
    return this;
  }

  public Profile setAvatarUrl(@Nullable String avatarUrl) {
    this.avatarUrl = avatarUrl;
    return this;
  }

  public Profile setProperty(String propertyKey, @Nullable Object propertyValue) {
    this.property.put(propertyKey, propertyValue);
    return this;
  }

  private Profile setProperty(HashMap<String, Object> property) {
    this.property = property;
    return this;
  }

  public String toJson() {
    Map<String, Object> profileMap = new HashMap<>();

    if (this.name != null) {
      profileMap.put(Const.PROFILE_NAME_KEY, this.name);
    }
    if (this.avatarUrl != null) {
      profileMap.put(Const.PROFILE_AVATAR_URL_KEY, this.avatarUrl);
    }
    if (this.mobileNumber != null) {
      profileMap.put(Const.PROFILE_MOBILE_NUMBER_KEY, this.mobileNumber);
    }
    if (this.email != null) {
      profileMap.put(Const.PROFILE_EMAIL_KEY, this.email);
    }

    for (Map.Entry<String, Object> entry : this.property.entrySet()) {
      profileMap.put(entry.getKey(), entry.getValue());
    }

    return new Gson().toJson(profileMap);
  }

  @Nullable
  @Deprecated
  public static Profile fromLegacy(@Nullable com.zoyi.channel.plugin.android.Profile profile) {
    if (profile != null) {
      return Profile.create()
          .setName(profile.getName())
          .setEmail(profile.getEmail())
          .setAvatarUrl(profile.getAvatarUrl())
          .setMobileNumber(profile.getMobileNumber())
          .setProperty(new HashMap<>(profile.getProperty()));
    }
    return null;
  }
}
