package com.zoyi.channel.plugin.android.model.etc;

import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;

public class Typing implements Entity {

  public static final long TTL = 30;

  private String action;
  private String chatId;
  private String chatType;
  private String personId;
  private String personType;
  private Long createdAt;

  public Typing() {
  }

  public Typing(String action, String chatId, String chatType) {
    this.action = action;
    this.chatId = chatId;
    this.chatType = chatType;
  }

  public String getAction() {
    return action;
  }

  public String getChatId() {
    return chatId;
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(Long createdAt) {
    this.createdAt = createdAt;
  }

  public ProfileEntity getProfileEntity() {
    return ProfileSelector.getProfile(personType, personId);
  }

  @Override
  public boolean equals(Object o) {
    boolean ret = false;
    if (o instanceof Typing) {
      Typing next = (Typing) o;

      ret = this.chatId.equals(next.chatId)
          && this.chatType.equals(next.chatType)
          && this.personId.equals(next.personId)
          && this.personType.equals(next.personType);
    }
    return ret;
  }

  @Override
  public String getId() {
    return String.format("%s:%s:%s:%s", chatType, chatId, personType, personId);
  }

  public static Typing dummy() {
    return new Typing();
  }

  public static Typing create(String action, String chatId) {
    return new Typing(action, chatId, UserChat.CLASSNAME);
  }
}
