package com.zoyi.channel.plugin.android.activity.language;

import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.activity.language.contract.LanguageSettingsContract;
import com.zoyi.channel.plugin.android.base.AbstractPresenter;
import com.zoyi.channel.plugin.android.open.option.Language;

public class LanguageSettingsPresenter
    extends AbstractPresenter<LanguageSettingsContract.View>
    implements LanguageSettingsContract.Presenter {

  public LanguageSettingsPresenter(LanguageSettingsContract.View view) {
    super(view);
  }

  @Override
  public void init() {
  }

  @Override
  public void changeLanguage(Language language) {
    view.showProgress(language);
    UserAction.updateLanguage(
        language.toString(),
        user -> {
          view.hideProgress();
          view.onLanguageChange(user.getLanguage());
        },
        s -> view.hideProgress()
    );
  }
}
