/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.util.AttributeSet;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.view.popup.BasePushView;
import com.zoyi.com.annimon.stream.Optional;
import java.util.Locale;

public class BubblePushView
extends BasePushView {
    public BubblePushView(@NonNull Context context) {
        super(context);
    }

    public BubblePushView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BubblePushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.ch_plugin_view_push_bubble;
    }

    @Override
    protected void setMediaSize(Previewable previewable) {
        this.avatarPopup.setVisibility(8);
        if (previewable.getHeight() != 0) {
            float maxRatio = 1.7777778f;
            float minRatio = 1.0f;
            float ratio = (float)previewable.getWidth().intValue() / previewable.getHeight().floatValue();
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.viewPopUpMedia.getLayoutParams();
            params.dimensionRatio = ratio < minRatio ? "1:1" : (ratio > maxRatio ? "16:9" : String.format(Locale.ENGLISH, "%d:%d", previewable.getWidth(), previewable.getHeight()));
        }
    }

    @Override
    public void show(Message message) {
        super.show(message);
        File file = message.getPrimaryFile();
        if (!(file == null || file.isPreviewable() && message.hasBlocks())) {
            this.viewFileRow.setVisibility(0);
            this.viewFileRow.setFile(file, message.getFiles().size());
        }
    }

    @Override
    protected int getDefaultTextMaxLine() {
        return (Integer)Optional.ofNullable((Object)this.item).map(Message::getPrimaryFile).filter(file -> !file.isPreviewable()).map(file -> 1).orElse((Object)2);
    }

    @Override
    protected int getAttachmentTextMaxLine() {
        return this.getDefaultTextMaxLine();
    }
}

