/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.lounge;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatUtils;
import com.zoyi.channel.plugin.android.activity.chats.ChatsActivity;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.watermark.ChannelWatermarkView;
import com.zoyi.channel.plugin.android.activity.lounge.LoungeAdapter;
import com.zoyi.channel.plugin.android.activity.lounge.LoungePresenter;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeContract;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderInteractionListener;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderView;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.LoungeIntegrationView;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.OnIntegrationClickListener;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.AppMessenger;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.AppMessengerSelector;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ChatsSelector;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.InAppPushStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.ClipboardUtils;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.rxpermission.RxPermissions;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.coordinator.LoungeCoordinatorLayout;
import com.zoyi.channel.plugin.android.view.coordinator.PaddingNestedScrollView;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.textview.EllipsizeTextView;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;
import com.zoyi.rx.functions.Action3;
import java.util.Collection;

public class LoungeActivity
extends BaseActivity2
implements LoungeContract.View,
OnChatClickListener,
LoungeHeaderInteractionListener,
OnIntegrationClickListener {
    private LoungeCoordinatorLayout layoutCoordinator;
    private LoungeHeaderView headerLounge;
    private View buttonCloseLounge;
    private View layoutPreviewHeader;
    private View layoutPreviewChat;
    private RecyclerView recyclerViewChat;
    private View buttonChatStartChats;
    private TextView textLoungePreviewChatStartChats;
    private View maskChatStartButton;
    private ChatStartButton buttonChatStartWelcome;
    private TextView textLoungeSeeMoreChats;
    private View layoutPreviewWelcome;
    private AvatarLayout avatarWelcomeMessageProfile;
    private TextView textWelcomeMessageProfile;
    private EllipsizeTextView textWelcomeMessage;
    private LoungeIntegrationView viewAppMessengers;
    private PaddingNestedScrollView scrollViewLounge;
    private ChannelWatermarkView watermark;
    private View layoutPreviewLoading;
    private ErrorRefreshView layoutPreviewError;
    private LoungeAdapter adapter;
    private LoungeContract.Presenter presenter;
    private LinearLayoutManager layoutManager;
    @Nullable
    private Binder appMessengersBinder;
    @Nullable
    private Binder moreChatBinder;
    @Nullable
    private Binder startChatBinder;
    private boolean canStartChat = true;
    @Nullable
    private String contentId = null;
    @Nullable
    private String presetMessage = null;
    private boolean handleOpenChat = false;
    private RxPermissions rxPermissions;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_lounge);
        this.setOutTransition(Transition.SLIDE_FROM_BOTTOM);
        this.layoutCoordinator = (LoungeCoordinatorLayout)this.findViewById(R.id.ch_layoutLoungeCoordinator);
        this.headerLounge = (LoungeHeaderView)this.findViewById(R.id.ch_viewLoungeHeader);
        this.headerLounge.setLoungeHeaderInteractionListener(this);
        this.buttonCloseLounge = this.findViewById(R.id.ch_buttonLoungeClose);
        this.buttonCloseLounge.setOnClickListener(v -> Action.invoke(ActionType.EXIT));
        this.layoutPreviewHeader = this.findViewById(R.id.ch_viewLoungePreviewHeader);
        this.layoutPreviewChat = this.findViewById(R.id.ch_layoutLoungePreviewChat);
        this.layoutPreviewWelcome = this.findViewById(R.id.ch_layoutLoungePreviewWelcomeMessage);
        this.layoutPreviewWelcome.setOnClickListener(v -> this.startChat(Transition.SLIDE_FROM_RIGHT));
        this.layoutPreviewLoading = this.findViewById(R.id.ch_layoutLoungePreviewLoader);
        this.layoutPreviewError = (ErrorRefreshView)this.findViewById(R.id.ch_layoutLoungePreviewError);
        this.layoutPreviewError.setListener(v -> this.presenter.fetchPreviewData());
        this.avatarWelcomeMessageProfile = (AvatarLayout)this.findViewById(R.id.ch_avatarLoungePreviewWelcomeMessage);
        this.textWelcomeMessageProfile = (TextView)this.findViewById(R.id.ch_textLoungePreviewWelcomeMessageName);
        this.textWelcomeMessage = (EllipsizeTextView)this.findViewById(R.id.ch_textLoungePreviewWelcomeMessageMessage);
        this.viewAppMessengers = (LoungeIntegrationView)this.findViewById(R.id.ch_viewAppMessengers);
        this.viewAppMessengers.setListener(this);
        this.rxPermissions = new RxPermissions((Activity)this);
        this.appMessengersBinder = AppMessengerSelector.bindIntegrations((Action3<Channel, Plugin, Collection<AppMessenger>>)((Action3)(channel, plugin, appMessengers) -> this.viewAppMessengers.addAppMessengers((Channel)channel, (Plugin)plugin, (Collection<AppMessenger>)appMessengers)));
        this.layoutCoordinator.setOnNestedScrollChangeListener((scrollPosition, headerHeight) -> {
            float maxScrollPosition = Math.min(scrollPosition, headerHeight);
            float closeButtonAlpha = maxScrollPosition / (float)headerHeight;
            this.headerLounge.setAlpha(1.0f - closeButtonAlpha);
            this.buttonCloseLounge.setAlpha(closeButtonAlpha);
            this.buttonCloseLounge.setVisibility(scrollPosition == 0 ? 8 : 0);
        });
        this.adapter = new LoungeAdapter();
        this.adapter.setListener(this);
        this.buttonChatStartChats = this.findViewById(R.id.ch_buttonLoungePreviewChatStartChats);
        this.buttonChatStartChats.setOnClickListener(v -> {
            if (this.canStartChat) {
                this.startChat(Transition.SLIDE_FROM_RIGHT);
            }
        });
        this.maskChatStartButton = this.findViewById(R.id.ch_imageLoungePreviewChatStartButtonMask);
        this.textLoungePreviewChatStartChats = (TextView)this.findViewById(R.id.ch_textLoungePreviewChatStartChats);
        this.startChatBinder = ChannelSelector.bindDisableStartChat((Action1<Boolean>)((Action1)disabled -> {
            this.canStartChat = disabled == false;
            this.maskChatStartButton.setBackgroundColor(ResUtils.getColor(disabled != false ? R.color.ch_grey500 : R.color.ch_grey900));
            this.textLoungePreviewChatStartChats.setTextColor(ResUtils.getColor(disabled != false ? R.color.ch_grey500 : R.color.ch_grey900));
        }));
        this.layoutManager = new LinearLayoutManager((Context)this);
        this.recyclerViewChat = (RecyclerView)this.findViewById(R.id.ch_recyclerViewLoungePreviewChat);
        this.recyclerViewChat.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerViewChat.setAdapter((RecyclerView.Adapter)this.adapter);
        this.recyclerViewChat.setItemAnimator(null);
        this.recyclerViewChat.getRecycledViewPool().setMaxRecycledViews(0, 40);
        this.watermark = (ChannelWatermarkView)this.findViewById(R.id.ch_viewLoungeWatermark);
        this.scrollViewLounge = (PaddingNestedScrollView)this.findViewById(R.id.ch_scrollViewLounge);
        this.scrollViewLounge.setListener(isBottomScrollable -> this.watermark.setBorderVisibility(isBottomScrollable));
        this.buttonChatStartWelcome = (ChatStartButton)this.findViewById(R.id.ch_buttonLoungePreviewChatStartWelcome);
        this.buttonChatStartWelcome.setOnClickListener(v -> this.startChat(Transition.SLIDE_FROM_RIGHT));
        this.textLoungeSeeMoreChats = (TextView)this.findViewById(R.id.ch_textLoungeSeeMoreChats);
        this.textLoungeSeeMoreChats.setOnClickListener(v -> this.showChats());
        this.moreChatBinder = ChatsSelector.bindUserChatsMore((Action2<Boolean, Integer>)((Action2)(hasNext, invisibleCount) -> {
            if (invisibleCount > 0) {
                this.textLoungeSeeMoreChats.setVisibility(0);
                this.textLoungeSeeMoreChats.setText((CharSequence)String.format(ResUtils.getString(hasNext != false ? "ch.lounge.show_previous_chats_more" : "ch.lounge.show_previous_chats"), invisibleCount));
            } else {
                this.textLoungeSeeMoreChats.setVisibility(8);
            }
        }));
        this.presenter = new LoungePresenter(this, this.adapter, this.adapter, this.getString("topActivityName"));
        this.bindPresenter(this.presenter);
        GlobalStore.get().messengerState.set(true);
        InAppPushStore.get().inAppPushMessage.set(null);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.contentId = intent.getStringExtra("chatContentId");
            this.presetMessage = intent.getStringExtra("chatPresetMessage");
            this.handleOpenChat = intent.getBooleanExtra("handleOpenChat", false);
        }
        return true;
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (intent != null) {
            this.contentId = intent.getStringExtra("chatContentId");
            this.presetMessage = intent.getStringExtra("chatPresetMessage");
            this.handleOpenChat = intent.getBooleanExtra("handleOpenChat", false);
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.isFinishing()) {
            GlobalStore.get().messengerState.set(false);
            Action.invoke(ActionType.MESSENGER_CLOSED);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.appMessengersBinder != null) {
            this.appMessengersBinder.unbind();
            this.appMessengersBinder = null;
        }
        if (this.moreChatBinder != null) {
            this.moreChatBinder.unbind();
            this.moreChatBinder = null;
        }
        if (this.startChatBinder != null) {
            this.startChatBinder.unbind();
            this.startChatBinder = null;
        }
    }

    @Override
    public void onPreviewStateChange(PreviewState previewState) {
        this.layoutPreviewChat.setVisibility(8);
        this.layoutPreviewHeader.setVisibility(8);
        this.layoutPreviewWelcome.setVisibility(8);
        this.layoutPreviewLoading.setVisibility(8);
        this.layoutPreviewError.setVisibility(8);
        this.buttonChatStartWelcome.setVisibility(8);
        switch (previewState) {
            case CHATS: {
                this.layoutPreviewHeader.setVisibility(0);
                this.layoutPreviewChat.setVisibility(0);
                break;
            }
            case WELCOME: {
                this.layoutPreviewWelcome.setVisibility(0);
                this.buttonChatStartWelcome.setVisibility(0);
                break;
            }
            case LOADING: {
                this.layoutPreviewLoading.setVisibility(0);
                break;
            }
            case FAILED: {
                this.layoutPreviewError.setVisibility(0);
            }
        }
        if ((previewState == PreviewState.WELCOME || previewState == PreviewState.CHATS) && this.handleOpenChat) {
            if (this.contentId != null) {
                this.startChat(ChatContentType.USER_CHAT, this.contentId, Transition.NONE);
            } else if (this.presetMessage != null) {
                this.startChat(this.presetMessage, Transition.NONE);
            } else {
                this.startChat(Transition.NONE);
            }
            this.contentId = null;
            this.presetMessage = null;
            this.handleOpenChat = false;
        }
    }

    @Override
    public void onDefaultProfileChange(ProfileEntity profileEntity) {
        if (profileEntity != null) {
            this.avatarWelcomeMessageProfile.set(profileEntity);
            this.textWelcomeMessageProfile.setText((CharSequence)profileEntity.getName());
        }
    }

    @Override
    public void onWelcomeMessageChange(String plainText) {
        if (plainText != null) {
            this.textWelcomeMessage.setText(plainText);
        }
    }

    @Override
    public void onChatItemClick(@NonNull ChatItem chatItem) {
        this.startChat(chatItem.getType(), chatItem.getSubKey(), Transition.SLIDE_FROM_RIGHT);
    }

    @Override
    public void onChatItemLongClick(@NonNull ChatItem chatItem) {
        ((ChannelDialog)((Object)((ChannelDialog)((Object)((ChannelDialog)((Object)new ChannelDialog((Context)this).setDescription(ResUtils.getString("ch.chat.delete_description")).addButton(ButtonType.CANCEL))).addButton(ButtonType.OK, v -> this.presenter.removeChat(chatItem)))).allowBackpress(true))).show();
    }

    @Override
    public void onLinkClick(String link) {
        if (ClipboardUtils.copyToClipBoard(link)) {
            Toast.makeText((Context)this, (CharSequence)ResUtils.getString("ch.integrations.copy_link.success"), (int)0).show();
        }
    }

    @Override
    public void onCallClick(String number) {
        if (number != null && Executor.canCall((Context)this)) {
            Executor.openCall((Context)this, number);
        } else {
            this.showPermissionDeniedToast();
        }
    }

    @Override
    public void onMessengerClick(AppMessenger appMessenger) {
        this.presenter.fetchConnect(appMessenger);
    }

    @Override
    public void onSettingsClick() {
        IntentUtils.setNextActivity((Context)this, SettingsActivity.class).startActivity();
    }

    @Override
    public void onExitClick() {
        Action.invoke(ActionType.EXIT);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 21 && resultCode == 22) {
            this.startChat(Transition.NONE);
        }
    }

    private void showChats() {
        IntentUtils.setNextActivity((Context)this, ChatsActivity.class).startActivity();
    }

    private void startChat(Transition transition) {
        this.startChat(null, transition);
    }

    private void startChat(@Nullable String presetMessage, Transition transition) {
        ChatUtils.createChatActivityIntent((Activity)this).putExtra("chatPresetMessage", presetMessage).setTransition(transition).startActivityForResult(21);
    }

    private void startChat(ChatContentType contentType, @Nullable String contentId, Transition transition) {
        if (contentType == ChatContentType.USER_CHAT && contentId != null) {
            ChatUtils.createChatActivityIntent((Activity)this).putExtra("chatContentType", contentType.toString()).putExtra("chatContentId", contentId).setTransition(transition).startActivityForResult(21);
        }
    }

    private void showPermissionDeniedToast() {
        Toast.makeText((Context)this, (CharSequence)ResUtils.getString("ch.permission.denied"), (int)1).show();
    }
}

