/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.profilebot;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.view.profilebot.BaseProfileBotInputView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class ProfileBotInputStringView
extends BaseProfileBotInputView {
    private ChBorderLayout borderLayout;
    private WatchedEditText editText;
    private View progressView;
    private View button;
    private AppCompatImageView imageSubmit;
    private FetchState fetchState = FetchState.COMPLETE;

    public ProfileBotInputStringView(@NonNull Context context) {
        super(context);
    }

    public ProfileBotInputStringView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ProfileBotInputStringView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    @Initializer
    public void initView(View root) {
        this.borderLayout = (ChBorderLayout)root.findViewById(R.id.ch_rootProfileBotInputStringView);
        this.editText = (WatchedEditText)root.findViewById(R.id.ch_editProfileBotInputString);
        this.progressView = root.findViewById(R.id.ch_progressProfileBotInputString);
        this.button = root.findViewById(R.id.ch_buttonProfileBotInputString);
        this.imageSubmit = (AppCompatImageView)root.findViewById(R.id.ch_imageProfileBotInputStringSubmit);
        this.editText.setOnFocusChangeListener((v, hasFocus) -> {
            this.resolveBorder(hasFocus);
            ProfileBotStore.get().requestFocus.set(true);
        });
        this.button.setOnClickListener(v -> this.submit());
    }

    @Override
    @Nullable
    public Object getValue() {
        if (this.editText != null && !this.editText.getString().isEmpty()) {
            return this.editText.getString();
        }
        return null;
    }

    @Override
    public void restore(@Nullable Object value, FetchState fetchState) {
        this.fetchState = fetchState;
        Views.setVisibility(this.progressView, fetchState == FetchState.LOADING);
        Views.setVisibility(this.button, fetchState != FetchState.LOADING);
        this.editText.setEnabled(fetchState != FetchState.LOADING);
        this.imageSubmit.setColorFilter(ResUtils.getColor(fetchState == FetchState.FAILED ? R.color.ch_orange400 : R.color.ch_cobalt400));
        this.resolveBorder(this.editText.hasFocus());
        if (value != null) {
            this.editText.setText(value.toString());
            this.editText.setSelection(this.editText.getString().length());
        } else {
            this.editText.setText(null);
        }
    }

    private void resolveBorder(boolean hasFocus) {
        if (this.fetchState == FetchState.FAILED) {
            this.borderLayout.setBorderColor(ResUtils.getColor(R.color.ch_orange400));
        } else {
            this.borderLayout.setBorderColor(ResUtils.getColor(hasFocus ? R.color.ch_cobalt400 : R.color.ch_grey300));
        }
    }

    @Override
    public void focus() {
        this.editText.requestFocus();
    }

    @Override
    public int getLayoutId() {
        return R.layout.ch_view_profile_bot_input_string;
    }
}

