/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.webview;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.v4.content.ContextCompat;
import android.view.MenuItem;
import android.view.View;
import android.webkit.URLUtil;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupMenu;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.util.ClipboardUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.handler.ButtonTouchHandler;

public class CHWebViewActivity
extends BaseActivity2
implements PopupMenu.OnMenuItemClickListener {
    private String TEXT_PAGE_LOADING = "Loading...";
    private LinearLayout layoutWebViewTitle;
    private TextView textWebViewTitle;
    private TextView textWebViewUrl;
    private TextView textWebViewLoading;
    private FrameLayout filterWebViewPreviousPageButton;
    private FrameLayout filterWebViewNextPageButton;
    private FrameLayout buttonWebViewPreviousPage;
    private FrameLayout buttonWebViewNextPage;
    private ImageView buttonWebViewRefresh;
    private ImageView buttonWebViewShareUrl;
    private ImageView buttonWebViewBack;
    private ImageView buttonWebViewMore;
    private ProgressBar progressBarWebView;
    private WebView webView;
    private String url;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_web_view, -1, true);
        this.initRes();
        this.url = this.getIntent().getStringExtra("url");
        if (this.url == null) {
            return false;
        }
        this.setWebView(this.url);
        this.setClickListener();
        return true;
    }

    @Initializer
    private void initRes() {
        this.layoutWebViewTitle = (LinearLayout)this.findViewById(R.id.ch_layoutWebViewTitle);
        this.textWebViewTitle = (TextView)this.findViewById(R.id.ch_textWebViewTitle);
        this.textWebViewUrl = (TextView)this.findViewById(R.id.ch_textWebViewUrl);
        this.textWebViewLoading = (TextView)this.findViewById(R.id.ch_textWebViewLoading);
        this.filterWebViewPreviousPageButton = (FrameLayout)this.findViewById(R.id.ch_layoutFilterWebViewPreviousPageButton);
        this.filterWebViewNextPageButton = (FrameLayout)this.findViewById(R.id.ch_layoutFilterWebViewNextPageButton);
        this.buttonWebViewPreviousPage = (FrameLayout)this.findViewById(R.id.ch_layoutButtonWebViewPreviousPage);
        this.buttonWebViewNextPage = (FrameLayout)this.findViewById(R.id.ch_layoutButtonWebViewNextPage);
        this.buttonWebViewRefresh = (ImageView)this.findViewById(R.id.ch_layoutButtonWebViewRefresh);
        this.buttonWebViewShareUrl = (ImageView)this.findViewById(R.id.ch_layoutButtonWebViewShareUrl);
        this.buttonWebViewBack = (ImageView)this.findViewById(R.id.ch_buttonWebViewBack);
        this.buttonWebViewMore = (ImageView)this.findViewById(R.id.ch_buttonWebViewMore);
        this.progressBarWebView = (ProgressBar)this.findViewById(R.id.ch_progressWebView);
        this.webView = (WebView)this.findViewById(R.id.ch_webView);
    }

    private void setWebView(String url) {
        this.textWebViewUrl.setText((CharSequence)url);
        WebSettings settings = this.webView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setLoadWithOverviewMode(true);
        settings.setUseWideViewPort(true);
        settings.setDomStorageEnabled(true);
        settings.setCacheMode(2);
        String customUserAgent = settings.getUserAgentString().replace("; wv", "");
        settings.setUserAgentString(customUserAgent);
        this.webView.loadUrl(url);
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                CHWebViewActivity.this.progressBarWebView.setProgress(newProgress);
            }

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
            }
        });
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView webView, String url) {
                if (UriUtils.isIntentUri(url)) {
                    Intent parsedIntent = null;
                    try {
                        parsedIntent = Intent.parseUri((String)url, (int)0);
                        CHWebViewActivity.this.startActivity(parsedIntent);
                    }
                    catch (Exception exception) {
                        return UriUtils.doFallBack((Context)CHWebViewActivity.this, parsedIntent);
                    }
                } else if (URLUtil.isNetworkUrl((String)url)) {
                    webView.loadUrl(url);
                } else {
                    return false;
                }
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                CHWebViewActivity.this.setWebViewVisibility(true);
                CHWebViewActivity.this.textWebViewLoading.setText((CharSequence)CHWebViewActivity.this.TEXT_PAGE_LOADING);
            }

            public void onPageFinished(WebView view, String url) {
                CHWebViewActivity.this.setWebViewVisibility(false);
                CHWebViewActivity.this.textWebViewTitle.setText((CharSequence)view.getTitle());
                CHWebViewActivity.this.setWebViewActionButtonState();
            }
        });
    }

    private void setWebViewActionButtonState() {
        this.filterWebViewPreviousPageButton.setBackgroundColor(this.webView.canGoBack() ? ContextCompat.getColor((Context)this, (int)R.color.ch_grey900) : ContextCompat.getColor((Context)this, (int)R.color.ch_grey200));
        this.filterWebViewNextPageButton.setBackgroundColor(this.webView.canGoForward() ? ContextCompat.getColor((Context)this, (int)R.color.ch_grey900) : ContextCompat.getColor((Context)this, (int)R.color.ch_grey200));
        this.buttonWebViewPreviousPage.setClickable(this.webView.canGoBack());
        this.buttonWebViewPreviousPage.setEnabled(this.webView.canGoBack());
        this.buttonWebViewNextPage.setClickable(this.webView.canGoForward());
        this.buttonWebViewNextPage.setEnabled(this.webView.canGoForward());
    }

    private void setWebViewVisibility(boolean loading) {
        Views.setVisibility((View)this.textWebViewLoading, loading);
        Views.setVisibility((View)this.layoutWebViewTitle, !loading);
        Views.setVisibility((View)this.progressBarWebView, loading);
    }

    private void setClickListener() {
        this.buttonWebViewBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CHWebViewActivity.this.finish();
            }
        });
        this.buttonWebViewBack.setOnTouchListener((View.OnTouchListener)new ButtonTouchHandler());
        this.buttonWebViewPreviousPage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CHWebViewActivity.this.webView.goBack();
            }
        });
        this.buttonWebViewPreviousPage.setOnTouchListener((View.OnTouchListener)new ButtonTouchHandler());
        this.buttonWebViewNextPage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CHWebViewActivity.this.webView.goForward();
            }
        });
        this.buttonWebViewNextPage.setOnTouchListener((View.OnTouchListener)new ButtonTouchHandler());
        this.buttonWebViewRefresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CHWebViewActivity.this.webView.reload();
            }
        });
        this.buttonWebViewRefresh.setOnTouchListener((View.OnTouchListener)new ButtonTouchHandler());
        this.buttonWebViewShareUrl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CHWebViewActivity.this.shareUrl(CHWebViewActivity.this.url);
            }
        });
        this.buttonWebViewShareUrl.setOnTouchListener((View.OnTouchListener)new ButtonTouchHandler());
        this.buttonWebViewMore.setOnClickListener(v -> {
            PopupMenu popupMenu = new PopupMenu((Context)this, v);
            popupMenu.getMenuInflater().inflate(R.menu.menu_webview_popup, popupMenu.getMenu());
            popupMenu.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)this);
            popupMenu.show();
        });
    }

    private void shareUrl(String url) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", url);
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"Share"));
    }

    public void onBackPressed() {
        if (this.canGoBack()) {
            this.webView.goBack();
        } else {
            super.onBackPressed();
        }
    }

    private boolean canGoBack() {
        return this.webView != null && this.webView.canGoBack();
    }

    public boolean onMenuItemClick(MenuItem item) {
        if (item.getItemId() == R.id.menuButtonExternalBrowser) {
            this.gotoExternalBrowser();
        } else if (item.getItemId() == R.id.menuButtonCopyLink) {
            ClipboardUtils.copyToClipBoard(this.url);
        }
        return false;
    }

    private void gotoExternalBrowser() {
        try {
            this.startActivity(new Intent("android.intent.action.VIEW").setData(Uri.parse((String)this.url)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

