/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.settings.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.settings.enumerate.OptionType;
import com.zoyi.channel.plugin.android.activity.settings.view.SettingsOptionInteractionListener;
import com.zoyi.channel.plugin.android.model.rest.I18n;
import com.zoyi.channel.plugin.android.model.rest.ProfileBotSchema;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.util.FormatUtils;
import com.zoyi.com.annimon.stream.Optional;

public class SettingsOptionView
extends LinearLayout
implements View.OnClickListener {
    private TextView textLabel;
    private TextView textValue;
    private TextView textPlaceholder;
    @Nullable
    private SettingsOptionInteractionListener settingsOptionInteractionListener;
    private OptionType optionType = OptionType.NONE;
    @Nullable
    private String key;
    @Nullable
    private Object value;

    public SettingsOptionView(Context context) {
        super(context);
        this.init(context);
    }

    public SettingsOptionView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SettingsOptionView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_settings_option, (ViewGroup)this, true);
        view.setOnClickListener((View.OnClickListener)this);
        this.textLabel = (TextView)view.findViewById(R.id.ch_textSettingsOptionLabel);
        this.textValue = (TextView)view.findViewById(R.id.ch_textSettingsOptionValue);
        this.textPlaceholder = (TextView)view.findViewById(R.id.ch_textSettingsOptionPlaceholder);
    }

    public void setSettingsOptionInteractionListener(@Nullable SettingsOptionInteractionListener settingsOptionInteractionListener) {
        this.settingsOptionInteractionListener = settingsOptionInteractionListener;
    }

    public void setData(OptionType optionType, String text) {
        this.optionType = optionType;
        this.key = null;
        this.value = null;
        this.textLabel.setVisibility(8);
        this.textValue.setVisibility(0);
        this.textValue.setText((CharSequence)text);
        this.textPlaceholder.setVisibility(8);
    }

    public void setData(ProfileBotSchema schema, User user) {
        this.optionType = OptionType.PROFILE;
        this.key = schema.getKey();
        this.value = user.getProfileValue(schema.getKey());
        this.textLabel.setVisibility(0);
        this.textLabel.setText((CharSequence)Optional.ofNullable((Object)schema).map(ProfileBotSchema::getNameI18n).map(I18n::get).orElse(null));
        if (this.value != null) {
            this.textValue.setVisibility(0);
            this.textPlaceholder.setVisibility(8);
            this.textValue.setText((CharSequence)FormatUtils.formatUserProfile(this.key, schema.getType(), this.value));
        } else {
            this.textValue.setVisibility(8);
            this.textPlaceholder.setVisibility(0);
        }
    }

    public void onClick(View v) {
        if (this.settingsOptionInteractionListener != null) {
            this.settingsOptionInteractionListener.onOptionClick(this.optionType, this.key, this.value);
        }
    }
}

