/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import com.splunk.mint.ActionMemoryTrim;
import com.splunk.mint.ForegroundHandler;
import java.text.DecimalFormat;

class MemoryTrimHandler
implements ComponentCallbacks2 {
    private static MemoryTrimHandler handler = new MemoryTrimHandler();

    private MemoryTrimHandler() {
    }

    public static void initialize(Application app) {
        try {
            app.unregisterComponentCallbacks((ComponentCallbacks)handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        app.registerComponentCallbacks((ComponentCallbacks)handler);
    }

    public void onTrimMemory(int level) {
        try {
            if (level == 20) {
                ForegroundHandler.applicationMovedToBackground();
            }
            ActivityManager.RunningAppProcessInfo processInfo = new ActivityManager.RunningAppProcessInfo();
            int lastTrimLevel = processInfo.lastTrimLevel;
            DecimalFormat nft = new DecimalFormat("#.##");
            Runtime runtime = Runtime.getRuntime();
            String memAppTotal = String.valueOf(nft.format((double)runtime.totalMemory() / 1024.0 / 1024.0));
            ActionMemoryTrim.createMemoryTrim(this.getLevel(level), this.getLevel(lastTrimLevel), memAppTotal).save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getLevel(int level) {
        String levelDesc = "NA";
        switch (level) {
            case 40: {
                levelDesc = "TRIM_MEMORY_BACKGROUND";
                break;
            }
            case 80: {
                levelDesc = "TRIM_MEMORY_COMPLETE";
                break;
            }
            case 60: {
                levelDesc = "TRIM_MEMORY_MODERATE";
                break;
            }
            case 15: {
                levelDesc = "TRIM_MEMORY_RUNNING_CRITICAL";
                break;
            }
            case 10: {
                levelDesc = "TRIM_MEMORY_RUNNING_LOW";
                break;
            }
            case 5: {
                levelDesc = "TRIM_MEMORY_RUNNING_MODERATE";
                break;
            }
            case 20: {
                levelDesc = "TRIM_MEMORY_UI_HIDDEN";
            }
        }
        return levelDesc;
    }

    public void onLowMemory() {
    }

    public void onConfigurationChanged(Configuration conf) {
    }
}

