/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.DataSaver;
import com.splunk.mint.InterfaceDataType;
import com.splunk.mint.Logger;
import com.splunk.mint.MintLogLevel;
import com.splunk.mint.NetSender;
import com.splunk.mint.Properties;
import com.splunk.mint.Utils;
import org.json.JSONException;
import org.json.JSONObject;

class ActionLog
extends BaseDTO
implements InterfaceDataType {
    public String eventName = "";
    public Integer eventLevel = 2;

    public ActionLog(byte type, String eventName, Integer level) {
        super(type, null);
        this.eventName = eventName;
        this.eventLevel = level;
    }

    public static final ActionLog createLog(String eventName, MintLogLevel level) {
        return new ActionLog(9, eventName, Utils.convertLoggingLevelToInt(level));
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            json.put("log_name", (Object)this.eventName);
            json.put("level", (Object)this.eventLevel);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString() + Properties.getSeparator(this.type);
    }

    @Override
    public void send(Context ctx, boolean saveOnFail) {
        NetSender.send(this.toJsonLine(), saveOnFail);
    }

    @Override
    public void save() {
        if (this.eventLevel != null) {
            if (this.eventLevel >= Properties.RemoteSettingsProps.logLevel) {
                DataSaver.save(this.toJsonLine());
            } else {
                Logger.logInfo("Logs's level is lower than the minimum level from Remote Settings, log will not be saved");
            }
        } else {
            DataSaver.save(this.toJsonLine());
        }
    }

    @Override
    public void send(boolean saveOnFail) {
        NetSender.send(this.toJsonLine(), saveOnFail);
    }
}

