package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.video_player.AttachmentVideoPlayerView;

import java.util.concurrent.TimeUnit;

public class AttachmentMediaThumbnailView extends MediaThumbnailView {

  public AttachmentMediaThumbnailView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public AttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public AttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private Context context;

  private void init(Context context) {
    this.context = context;

    setBorderRadius(Utils.dpToPx(context, 6));
    setBorderWidth(Utils.dpToPx(context, 1));
    setBorderColor(ResUtils.getColor(context, R.color.ch_grey300));
  }

  @Nullable
  private String messageId;
  @Nullable
  private File attachment = null;
  @Nullable
  private OnAttachmentContentActionListener listener = null;

  public void setAttachment(
      @Nullable String messageId,
      File attachment,
      @Nullable OnAttachmentContentActionListener listener
  ) {
    this.messageId = messageId;
    this.attachment = attachment;
    this.listener = listener;

    if (messageId != null && attachment.getUrl() != null) {
      if (attachment.isVideo()) {
        activatePlayButton();
        activateDuration(attachment.getDuration() * TimeUnit.SECONDS.toMillis(1));
      } else if (attachment.isImage()) {
        setOnClickListener(v -> {
          if (this.listener != null && this.attachment != null) {
            this.listener.onAttachmentClick(this.attachment);
          }
        });
      }

      setOnLongClickListener(v -> {
        if (this.listener != null && this.attachment != null) {
          this.listener.onAttachmentLongClick(this.attachment);
          return true;
        }
        return false;
      });
    }
  }

  @Override
  public void onPlayClick() {
    if (attachment != null) {
      super.onPlayClick();

      AttachmentVideoPlayerView view = new AttachmentVideoPlayerView(context)
          .setUrl(messageId, attachment, listener, null);

      view.setOnLongClickListener(v -> {
        if (listener != null && attachment != null) {
          listener.onAttachmentLongClick(attachment);
          return true;
        }
        return false;
      });

      if (listener != null) {
        listener.onAttachmentActionClick();
      }

      appendVideoView(view);
    }
  }

  @Override
  public void clear() {
    super.clear();

    this.attachment = null;
    this.listener = null;

    setOnClickListener(null);
    setOnLongClickListener(null);
  }
}
