package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.okhttp3.*;

import java.io.IOException;

/**
 * Created by mika on 2016. 3. 14..
 */
public class LanguageInterceptor implements Interceptor {

  @Override
  public Response intercept(Chain chain) throws IOException {
    Request request = chain.request();

    Request.Builder builder = request.newBuilder();

    if (request.header(Const.ACCEPT_LANGUAGE) == null) {
      builder = builder.header(Const.ACCEPT_LANGUAGE, SettingsStore.get().language.get().toString());
    }

    return chain.proceed(builder.build());
  }
}
