/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.attachment;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.activity.chat.view.attachment.AttachmentGroupGridLayout;
import com.zoyi.channel.plugin.android.activity.chat.view.attachment.AttachmentGroupLinearLayout;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.MessageContentView;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.com.annimon.stream.Collectors;
import com.zoyi.com.annimon.stream.Stream;
import java.util.ArrayList;
import java.util.List;

public class AttachmentsLayout
extends LinearLayout
implements MessageContentView {
    private AttachmentGroupLinearLayout layoutAttachmentsGroupOrigin;
    private AttachmentGroupGridLayout layoutAttachmentsGroupGrid;
    private AttachmentGroupLinearLayout layoutAttachmentsGroupOthers;
    private int attachmentsMaxWidth;

    public AttachmentsLayout(Context context) {
        super(context);
        this.init(context);
    }

    public AttachmentsLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AttachmentsLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_holder_item_layout_attachments, (ViewGroup)this);
        this.layoutAttachmentsGroupOrigin = (AttachmentGroupLinearLayout)this.findViewById(R.id.ch_layoutAttachmentsGroupOrigin);
        this.layoutAttachmentsGroupGrid = (AttachmentGroupGridLayout)this.findViewById(R.id.ch_layoutAttachmentsGroupGrid);
        this.layoutAttachmentsGroupOthers = (AttachmentGroupLinearLayout)this.findViewById(R.id.ch_layoutAttachmentsGroupOthers);
        this.attachmentsMaxWidth = ResUtils.getDimen(context, R.dimen.ch_chat_message_attachments_max_width);
    }

    public void setGravity(int gravity) {
        super.setGravity(gravity);
        this.layoutAttachmentsGroupOrigin.setGravity(gravity);
        this.layoutAttachmentsGroupOthers.setGravity(gravity);
    }

    public void setAttachments(@Nullable String messageId, @Nullable List<File> files, @Nullable OnAttachmentContentActionListener listener) {
        ArrayList linearGroup = (ArrayList)Stream.ofNullable(files).filter(File::isVideo).collect(Collectors.toCollection(ArrayList::new));
        ArrayList gridGroup = (ArrayList)Stream.ofNullable(files).filter(File::isImage).collect(Collectors.toCollection(ArrayList::new));
        ArrayList otherGroup = (ArrayList)Stream.ofNullable(files).filter(file -> !file.isVideo() && !file.isImage()).collect(Collectors.toCollection(ArrayList::new));
        if (gridGroup.size() == 1) {
            linearGroup.addAll(gridGroup);
            gridGroup.clear();
        }
        this.layoutAttachmentsGroupOrigin.setAttachments(messageId, linearGroup, listener);
        this.layoutAttachmentsGroupGrid.setAttachments(messageId, gridGroup, listener);
        this.layoutAttachmentsGroupOthers.setAttachments(messageId, otherGroup, listener);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int newWidthMeasureSpec = width > this.attachmentsMaxWidth ? View.MeasureSpec.makeMeasureSpec((int)this.attachmentsMaxWidth, (int)0x40000000) : widthMeasureSpec;
        super.onMeasure(newWidthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void resetView() {
        this.setVisibility(8);
        this.layoutAttachmentsGroupOrigin.resetView();
        this.layoutAttachmentsGroupGrid.resetView();
        this.layoutAttachmentsGroupOthers.resetView();
    }

    @Override
    public void clear() {
        this.layoutAttachmentsGroupOrigin.clear();
        this.layoutAttachmentsGroupGrid.clear();
        this.layoutAttachmentsGroupOthers.clear();
    }
}

