/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.channel.plugin.android.view.layout.ProfileLayout;

public class AvatarLayout
extends ProfileLayout {
    private MaskableFrameLayout layoutAvatar;
    private View border;
    private int borderSize = 0;
    @ColorInt
    private int borderColor = -1;

    public AvatarLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public AvatarLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public AvatarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    protected void init(Context context, @Nullable AttributeSet attrs) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_avatar, (ViewGroup)this);
        super.init(context, root, attrs);
        this.layoutAvatar = (MaskableFrameLayout)root.findViewById(R.id.ch_layoutAvatar);
        this.border = root.findViewById(R.id.ch_borderAvatar);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ProfileLayout, 0, 0);
            try {
                this.borderSize = typedArray.getDimensionPixelSize(R.styleable.ProfileLayout_ch_border_size, this.borderSize);
                this.borderColor = typedArray.getInt(R.styleable.ProfileLayout_ch_border_color, this.borderColor);
            }
            finally {
                typedArray.recycle();
            }
        }
        this.setBorder();
    }

    private void setBorder() {
        if (this.borderSize > 0) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.layoutAvatar.getLayoutParams();
            params.setMargins(this.borderSize, this.borderSize, this.borderSize, this.borderSize);
            this.layoutAvatar.setLayoutParams((ViewGroup.LayoutParams)params);
            this.border.getBackground().setColorFilter(this.borderColor, PorterDuff.Mode.SRC_ATOP);
            this.border.setVisibility(0);
        } else {
            this.border.setVisibility(8);
        }
    }

    public void setBorderSize(int borderSize) {
        this.setBorder(borderSize, this.borderColor);
    }

    @Override
    public void setBorderColor(@ColorInt int borderColor) {
        this.setBorder(this.borderSize, borderColor);
    }

    public void setBorder(int borderSize, @ColorInt int borderColor) {
        this.borderSize = borderSize;
        this.borderColor = borderColor;
        this.setBorder();
    }
}

