/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.functions.Func2;
import com.zoyi.rx.internal.util.UtilityFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorSequenceEqual {
    static final Object LOCAL_ON_COMPLETED = new Object();

    private OperatorSequenceEqual() {
        throw new IllegalStateException("No instances!");
    }

    static <T> Observable<Object> materializeLite(Observable<T> source) {
        return Observable.concat(source, Observable.just(LOCAL_ON_COMPLETED));
    }

    public static <T> Observable<Boolean> sequenceEqual(Observable<? extends T> first, Observable<? extends T> second, final Func2<? super T, ? super T, Boolean> equality) {
        Observable<Object> firstObservable = OperatorSequenceEqual.materializeLite(first);
        Observable<Object> secondObservable = OperatorSequenceEqual.materializeLite(second);
        return Observable.zip(firstObservable, secondObservable, new Func2<Object, Object, Boolean>(){

            @Override
            public Boolean call(Object t1, Object t2) {
                boolean c2;
                boolean c1 = t1 == LOCAL_ON_COMPLETED;
                boolean bl = c2 = t2 == LOCAL_ON_COMPLETED;
                if (c1 && c2) {
                    return true;
                }
                if (c1 || c2) {
                    return false;
                }
                return (Boolean)equality.call(t1, t2);
            }
        }).all(UtilityFunctions.identity());
    }
}

