/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnSubscribeRange
implements Observable.OnSubscribe<Integer> {
    private final int startIndex;
    private final int endIndex;

    public OnSubscribeRange(int start, int end) {
        this.startIndex = start;
        this.endIndex = end;
    }

    @Override
    public void call(Subscriber<? super Integer> childSubscriber) {
        childSubscriber.setProducer(new RangeProducer(childSubscriber, this.startIndex, this.endIndex));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RangeProducer
    extends AtomicLong
    implements Producer {
        private static final long serialVersionUID = 4114392207069098388L;
        private final Subscriber<? super Integer> childSubscriber;
        private final int endOfRange;
        private long currentIndex;

        RangeProducer(Subscriber<? super Integer> childSubscriber, int startIndex, int endIndex) {
            this.childSubscriber = childSubscriber;
            this.currentIndex = startIndex;
            this.endOfRange = endIndex;
        }

        @Override
        public void request(long requestedAmount) {
            long c;
            if (this.get() == Long.MAX_VALUE) {
                return;
            }
            if (requestedAmount == Long.MAX_VALUE && this.compareAndSet(0L, Long.MAX_VALUE)) {
                this.fastPath();
            } else if (requestedAmount > 0L && (c = BackpressureUtils.getAndAddRequest(this, requestedAmount)) == 0L) {
                this.slowPath(requestedAmount);
            }
        }

        void slowPath(long requestedAmount) {
            long emitted = 0L;
            long endIndex = (long)this.endOfRange + 1L;
            long index = this.currentIndex;
            Subscriber<? super Integer> childSubscriber = this.childSubscriber;
            while (true) {
                if (emitted != requestedAmount && index != endIndex) {
                    if (childSubscriber.isUnsubscribed()) {
                        return;
                    }
                    childSubscriber.onNext((Integer)((int)index));
                    ++index;
                    ++emitted;
                    continue;
                }
                if (childSubscriber.isUnsubscribed()) {
                    return;
                }
                if (index == endIndex) {
                    childSubscriber.onCompleted();
                    return;
                }
                requestedAmount = this.get();
                if (requestedAmount != emitted) continue;
                this.currentIndex = index;
                requestedAmount = this.addAndGet(-emitted);
                if (requestedAmount == 0L) break;
                emitted = 0L;
            }
        }

        void fastPath() {
            long endIndex = (long)this.endOfRange + 1L;
            Subscriber<? super Integer> childSubscriber = this.childSubscriber;
            for (long index = this.currentIndex; index != endIndex; ++index) {
                if (childSubscriber.isUnsubscribed()) {
                    return;
                }
                childSubscriber.onNext((Integer)((int)index));
            }
            if (!childSubscriber.isUnsubscribed()) {
                childSubscriber.onCompleted();
            }
        }
    }
}

