/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.observers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorSkipUntil<T, U>
implements Observable.Operator<T, T> {
    final Observable<U> other;

    public OperatorSkipUntil(Observable<U> other) {
        this.other = other;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        final AtomicBoolean gate = new AtomicBoolean();
        Subscriber u = new Subscriber<U>(){

            @Override
            public void onNext(U t) {
                gate.set(true);
                this.unsubscribe();
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                s.unsubscribe();
            }

            @Override
            public void onCompleted() {
                this.unsubscribe();
            }
        };
        child.add(u);
        this.other.unsafeSubscribe(u);
        return new Subscriber<T>(child){

            @Override
            public void onNext(T t) {
                if (gate.get()) {
                    s.onNext(t);
                } else {
                    this.request(1L);
                }
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                this.unsubscribe();
            }

            @Override
            public void onCompleted() {
                s.onCompleted();
                this.unsubscribe();
            }
        };
    }
}

