/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.model.LogMessageItem;
import com.zoyi.channel.plugin.android.base.adapter.BaseViewHolder;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TextDecorator;

public class LogMessageHolder
extends BaseViewHolder {
    private Context context;
    private View root;
    private TextView textLog;
    private int datetimeSize;

    public static LogMessageHolder newInstance(ViewGroup parent) {
        return new LogMessageHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ch_plugin_item_message_log, parent, false));
    }

    private LogMessageHolder(View itemView) {
        super(itemView);
        this.context = itemView.getContext();
        this.root = itemView;
        this.textLog = (TextView)itemView.findViewById(R.id.ch_textMessageLog);
        this.datetimeSize = (int)this.context.getResources().getDimension(R.dimen.ch_log_message_date_text_size);
    }

    public void bind(LogMessageItem item) {
        if (item != null && item.getCreatedTime() != null && item.isCloseLog()) {
            String messageTime = item.getCreatedTime();
            SpannableString result = new SpannableString((CharSequence)String.format("%s  %s", ResUtils.getString(this.context, "ch.log.resolved"), messageTime));
            result = TextDecorator.color(result, messageTime, ContextCompat.getColor((Context)this.context, (int)R.color.ch_grey500));
            result = TextDecorator.size(result, messageTime, this.datetimeSize);
            this.textLog.setText((CharSequence)result);
            this.root.setVisibility(0);
        } else {
            this.root.setVisibility(8);
        }
    }
}

