package com.zoyi.channel.plugin.android.manager;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.rx.Observable;
import com.zoyi.rx.subjects.PublishSubject;

import java.util.HashMap;
import java.util.Map;

public class ChatVideoManager {

  private PublishSubject<String> stopSignalProcessor = PublishSubject.create();

  @Nullable
  private Integer activeContextHashCode;
  @Nullable
  private String activeVideoId;

  private Map<String, Long> videoPositions = new HashMap<>();
  private Map<String, Boolean> videoVolumeStates = new HashMap<>();

  public Observable<String> attachStopSignal() {
    return stopSignalProcessor.onBackpressureBuffer();
  }

  public void onVideoStarted(Context context, @Nullable String id) {
    if (!CompareUtils.isSame(id, activeVideoId)) {
      stopActiveVideo();
    }

    if (id != null) {
      this.activeContextHashCode = context.hashCode();
      this.activeVideoId = id;
    }
  }

  public void onVideoStopped(Context context, @Nullable String id) {
    if (activeContextHashCode != null && context.hashCode() == activeContextHashCode && CompareUtils.isSame(id, activeVideoId)) {
      reset();
    }
  }

  public void onVideoProgressChanged(@Nullable String id, Long position) {
    if (activeVideoId != null && activeVideoId.equals(id)) {
      videoPositions.put(id, position);
    }
  }

  public void onVideoVolumeStateChanged(@Nullable String id, boolean isVolumeOn) {
    if (id != null) {
      videoVolumeStates.put(id, isVolumeOn);
    }
  }

  @Nullable
  public Long getVideoPosition(@Nullable String id) {
    return Optional.ofNullable(id).map(it -> videoPositions.get(it)).orElse(null);
  }

  @Nullable
  public Boolean getVideoVolumeState(@Nullable String id) {
    return Optional.ofNullable(id).map(it -> videoVolumeStates.get(it)).orElse(null);
  }

  public void onActivityPaused(Activity activity) {
    if (activeContextHashCode != null && activity.hashCode() == activeContextHashCode) {
      stopActiveVideo();

      reset();
    }
  }

  private void stopActiveVideo() {
    if (activeContextHashCode != null && activeVideoId != null) {
      stopSignalProcessor.onNext(activeVideoId);
    }
  }

  // private functions

  private void reset() {
    this.activeContextHashCode = null;
    this.activeVideoId = null;
  }

  public void clear() {
    this.activeContextHashCode = null;
    this.activeVideoId = null;

    videoPositions.clear();
    videoVolumeStates.clear();
  }

  @Nullable
  private static ChatVideoManager instance;

  public static ChatVideoManager get() {
    if (instance == null) {
      instance = new ChatVideoManager();
    }
    return instance;
  }
}
