package com.zoyi.channel.plugin.android.activity.download;

import android.Manifest;
import android.content.Intent;
import android.graphics.Color;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.MimeTypeMap;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.ChannelFileProvider;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.DownloadUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import com.zoyi.channel.plugin.android.util.rxpermission.RxPermissions;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimationListener;
import com.zoyi.channel.plugin.android.view.layout.DownloadProgressBar;
import com.zoyi.okhttp3.Call;

import java.io.File;

/**
 * Created by mika on 2017. 1. 11..
 */
public class DownloadActivity extends BaseActivity2 implements View.OnClickListener {

  private DownloadProgressBar progress;
  private View imageDone;
  private View buttonCancel;

  @Nullable
  private String url, filename;
  private boolean image;
  @Nullable
  private Call call;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_download, Color.BLACK, false);

    progress = findViewById(R.id.ch_progressDownload);
    imageDone = findViewById(R.id.ch_imageDownloadDone);
    buttonCancel = findViewById(R.id.ch_buttonDownloadCancel);

    buttonCancel.setOnClickListener(this);

    if (getIntent() != null) {
      url = getIntent().getStringExtra(Const.EXTRA_URL);
      filename = getIntent().getStringExtra(Const.EXTRA_FILE_NAME);
      image = getIntent().getBooleanExtra(Const.EXTRA_IMAGE, false);

      if (!TextUtils.isEmpty(url) && !TextUtils.isEmpty(filename)) {
        new RxPermissions(this)
            .request(Manifest.permission.WRITE_EXTERNAL_STORAGE)
            .subscribe(granted -> {
              if (granted) {
                startDownload();
              } else {
                finish(Const.DOWNLOAD_FAILED);
              }
            });
        return true;
      }
    }
    return false;
  }

  @Override
  public void onBackPressed() {
    // ignore back press
  }

  @Override
  public void finish(int resultCode) {
    super.finish(resultCode, Transition.NONE);
  }

  @Override
  protected void onPause() {
    super.onPause();
    overridePendingTransition(0, 0);
  }

  @Override
  public void onClick(View view) {
    int id = view.getId();

    if (id == R.id.ch_buttonDownloadCancel) {
      try {
        if (call != null && !call.isCanceled()) {
          call.cancel();
        }
      } catch (Exception ignored) {
      }
    }
  }

  private void startDownload() {
    call = DownloadUtils.downloadFile(
        this,
        url,
        filename,
        image,
        new DownloadUtils.ProgressListener() {
          @Override
          public void update(int progress) {
            progressDownload(progress);
          }

          @Override
          public void error(Call call, String message) {
            L.e(message);

            if (call == null || !call.isCanceled()) {
              finish(Const.DOWNLOAD_FAILED);
            } else {
              finish(Const.DOWNLOAD_CANCEL);
            }
          }

          @Override
          public void done(String savePath) {
            finishDownload(savePath);
          }
        });

    if (call == null) {
      finish(Const.DOWNLOAD_FAILED);
    }
  }

  private void progressDownload(int progress) {
    this.progress.setProgress(progress);
  }

  private void finishDownload(String savePath) {
    imageDone.setVisibility(View.VISIBLE);
    buttonCancel.setVisibility(View.GONE);
    progress.setVisibility(View.GONE);

    if (!image) {
      File file = new File(savePath);
      if (file.exists()) {
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        String ext = FilenameUtils.getExtension(savePath).toLowerCase();
        String type = mimeTypeMap.getMimeTypeFromExtension(ext);

        try {
          Intent intent = new Intent(Intent.ACTION_VIEW);

          intent.setDataAndType(ChannelFileProvider.getUriForFile(this, file), type);
          intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
          intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);

          startActivity(intent);
        } catch (Exception ex) {
          L.e(ex.getMessage());
        }
      }
    }

    Animation animation = AnimationUtils.loadAnimation(this, R.anim.ch_plugin_dialog_in);
    animation.setAnimationListener(new SimpleAnimationListener() {
      @Override
      public void onAnimationEnd(Animation animation) {
        finish(Const.DOWNLOAD_COMPLETE);
      }
    });
    imageDone.startAnimation(animation);
  }
}
