package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.com.annimon.stream.Optional;

public class UserMessageHolder extends AbsUserMessageHolder {

  @Nullable
  private OnMessageActionListener listener;
  @Nullable
  private Message message;

  private UserMessageHolder(View itemView, @Nullable OnMessageActionListener listener) {
    super(itemView, listener);

    this.listener = listener;
  }

  public void bind(ChatMessageItem item, boolean showDate, boolean isHead, boolean isTail) {
    super.bind(item.getCreatedAt(), showDate, isHead, isTail);

    this.message = item.getMessage();

    String messageId = Optional.ofNullable(item.getMessage()).map(Message::getId).orElse(null);

    // set text
    if (item.getMessage() != null && item.getMessage().getBlocks() != null) {
      setBlocks(item.getMessage().getBlocks());
    }

    // set web page
    Optional.ofNullable(item.getMessage()).map(Message::getWebPage).ifPresent(webPage -> setWebPage(messageId, webPage));

    setAttachments(
        Optional.ofNullable(item.getMessage()).map(Message::getId).orElse(null),
        item.getMessage().getFiles(),
        this
    );
  }

  @Override
  public void onAttachmentClick(File attachment) {
    super.onAttachmentClick(attachment);

    if (listener != null && message != null) {
      listener.onAttachmentClick(attachment, message);
    }
  }

  public static UserMessageHolder newInstance(ViewGroup parent, @Nullable OnMessageActionListener listener) {
    return new UserMessageHolder(getItemView(parent), listener);
  }

  @Override
  protected void clear() {
    super.clear();

    this.message = null;
  }
}
