package com.zoyi.channel.plugin.android;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.com.google.gson.Gson;

import java.util.HashMap;
import java.util.Map;

/**
 * @deprecated Use {@link com.zoyi.channel.plugin.android.open.model.Profile}
 */
@Deprecated
public class Profile {
  @Nullable
  private String name;
  @Nullable
  private String email;
  @Nullable
  private String avatarUrl;
  @Nullable
  private String mobileNumber;
  private Map<String, Object> property;

  /**
   * @return profile
   * @deprecated Use {@link com.zoyi.channel.plugin.android.open.model.Profile#create()}
   */
  @Deprecated
  public static Profile create() {
    L.w("Profile model is move to com.zoyi.channel.plugin.android.open.model.Profile");
    return new Profile();
  }
  private Profile() {
    property = new HashMap<>();
  }

  @Nullable
  public String getName() {
    return name;
  }

  @Nullable
  public String getEmail() {
    return email;
  }

  @Nullable
  public String getMobileNumber() {
    return mobileNumber;
  }

  @Nullable
  public String getAvatarUrl() {
    return avatarUrl;
  }

  public Map<String, Object> getProperty() {
    return property;
  }

  public Profile setName(String name) {
    this.name = name;
    return this;
  }

  public Profile setEmail(String email) {
    this.email = email;
    return this;
  }

  public Profile setMobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
    return this;
  }

  public Profile setAvatarUrl(String avatarUrl) {
    this.avatarUrl = avatarUrl;
    return this;
  }

  public Profile setProperty(String propertyKey, Object propertyValue) {
    this.property.put(propertyKey, propertyValue);
    return this;
  }

  public String toJson() {
    Map<String, Object> profileMap = new HashMap<>();

    if (this.name != null) {
      profileMap.put(Const.PROFILE_NAME_KEY, this.name);
    }
    if (this.avatarUrl != null) {
      profileMap.put(Const.PROFILE_AVATAR_URL_KEY, this.avatarUrl);
    }
    if (this.mobileNumber != null) {
      profileMap.put(Const.PROFILE_MOBILE_NUMBER_KEY, this.mobileNumber);
    }
    if (this.email != null) {
      profileMap.put(Const.PROFILE_EMAIL_KEY, this.email);
    }

    for (Map.Entry<String, Object> entry : this.property.entrySet()) {
      profileMap.put(entry.getKey(), entry.getValue());
    }

    return new Gson().toJson(profileMap);
  }
}
