package com.zoyi.channel.plugin.android.push;

import android.os.Bundle;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.global.Const;

class PushData {

  private static final String CHANNEL_IO = "Channel.io";

  private String provider;
  private String channelId;
  private String personType;
  private String personId;
  private String avatarUrl;
  private String chatId;
  private String message;

  PushData(Bundle bundle) {
    provider = bundle.getString(Const.EXTRA_PROVIDER);
    channelId = bundle.getString(Const.EXTRA_CHANNEL_ID);
    personType = bundle.getString(Const.EXTRA_PERSON_TYPE);
    personId = bundle.getString(Const.EXTRA_PERSON_ID);
    avatarUrl = bundle.getString(Const.EXTRA_AVATAR_URL);
    chatId = bundle.getString(Const.EXTRA_CHAT_ID);
    message = bundle.getString(Const.EXTRA_MESSAGE);
  }

  public String getChannelId() {
    return channelId;
  }

  public String getPersonType() {
    return personType;
  }

  public String getPersonId() {
    return personId;
  }

  public String getAvatarUrl() {
    return avatarUrl;
  }

  public String getChatId() {
    return chatId;
  }

  public String getMessage() {
    return message;
  }

  public boolean isChannelPluginMessage() {
    return !TextUtils.isEmpty(provider) && provider.equals(CHANNEL_IO);
  }
}
