/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDialog<E extends BaseDialog>
extends Dialog {
    private TextView textTitle;
    private FrameLayout contentLayout;
    private LinearLayout buttonLayout;
    private Context context;
    private String title;
    @Nullable
    private View content;
    private List<Button> buttons;
    private int orientation;

    public BaseDialog(@NonNull Context context) {
        super(context);
        this.context = context;
        this.buttons = new ArrayList<Button>();
        this.orientation = 0;
    }

    @Initializer
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.requestWindowFeature(1);
        this.setContentView(R.layout.ch_dialog_base);
        this.textTitle = (TextView)this.findViewById(R.id.dialog_title_txt);
        this.contentLayout = (FrameLayout)this.findViewById(R.id.dialog_content);
        this.buttonLayout = (LinearLayout)this.findViewById(R.id.dialog_button_frame);
        this.setDialogView();
    }

    private void setDialogView() {
        if (this.title != null) {
            this.textTitle.setVisibility(0);
            this.textTitle.setText((CharSequence)this.title);
        }
        if (this.content != null) {
            this.contentLayout.addView(this.content);
        }
        this.buttonLayout.setOrientation(this.orientation);
        for (Button button : this.buttons) {
            if (this.orientation == 1) {
                button.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
            } else {
                button.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
            }
            this.buttonLayout.addView((View)button);
        }
    }

    protected Button createButton(String text) {
        Button button = (Button)LayoutInflater.from((Context)this.context).inflate(R.layout.ch_dialog_button, null);
        button.setText((CharSequence)text);
        return button;
    }

    protected void addButton(Button button) {
        this.buttons.add(button);
    }

    public E setTitle(String title) {
        this.title = title;
        return (E)((Object)this);
    }

    protected E setContent(View content) {
        this.content = content;
        return (E)((Object)this);
    }

    public E setButtonOrientation(int orientation) {
        this.orientation = orientation;
        return (E)((Object)this);
    }

    public E addButton(ButtonType type) {
        return this.addButton(type, null);
    }

    public E addButton(ButtonType type, @Nullable View.OnClickListener listener) {
        switch (type) {
            case CANCEL: {
                return this.addButton(ResUtils.getString(this.context, "ch.common_cancel"), listener);
            }
        }
        return this.addButton(ResUtils.getString(this.context, "ch.common_confirm"), listener);
    }

    public E addButton(String text) {
        return this.addButton(text, null);
    }

    public E addButton(String text, final @Nullable View.OnClickListener listener) {
        Button button = this.createButton(text);
        if (listener != null) {
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    listener.onClick(v);
                    BaseDialog.this.dismiss();
                }
            });
        } else {
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BaseDialog.this.dismiss();
                }
            });
        }
        this.addButton(button);
        return (E)((Object)this);
    }

    public E allowBackpress(boolean allow) {
        this.setCancelable(allow);
        return (E)((Object)this);
    }
}

