/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.base;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.contract.BasePresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.rx.Subscription;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPresenter<V extends BaseView>
implements BasePresenter {
    protected V view;
    @Nullable
    private List<Binder> binders;
    @Nullable
    private Subscription subscription;

    public AbstractPresenter(V view) {
        this.view = view;
        this.subscription = Action.observable().subscribe(actionType -> {
            this.handleBaseAction((ActionType)((Object)actionType));
            this.handleAction((ActionType)((Object)actionType));
        });
    }

    protected void bind(Binder binder) {
        if (this.binders == null) {
            this.binders = new ArrayList<Binder>();
        }
        this.binders.add(binder);
    }

    @Override
    public abstract void init();

    private void handleBaseAction(ActionType actionType) {
        switch (actionType) {
            case EXIT: {
                this.view.finish(Transition.SLIDE_FROM_BOTTOM);
                break;
            }
            case SHUTDOWN: {
                this.view.finish(Transition.NONE);
            }
        }
    }

    protected void handleAction(ActionType actionType) {
    }

    @Override
    public void release() {
        if (this.binders != null) {
            for (Binder binder : this.binders) {
                if (binder == null) continue;
                binder.unbind();
            }
            this.binders.clear();
            this.binders = null;
        }
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }
}

