package com.zoyi.channel.plugin.android.activity.webview;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.support.v4.content.ContextCompat;
import android.view.MenuItem;
import android.view.View;
import android.webkit.*;
import android.widget.*;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.ClipboardUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.handler.ButtonTouchHandler;

/**
 * Created by jerry on 2018. 8. 2..
 */

public class CHWebViewActivity extends BaseActivity2 implements PopupMenu.OnMenuItemClickListener {

  private String TEXT_PAGE_LOADING = "Loading...";

  private LinearLayout layoutWebViewTitle;
  private TextView textWebViewTitle;
  private TextView textWebViewUrl;
  private TextView textWebViewLoading;

  private FrameLayout filterWebViewPreviousPageButton;
  private FrameLayout filterWebViewNextPageButton;

  private FrameLayout buttonWebViewPreviousPage;
  private FrameLayout buttonWebViewNextPage;
  private ImageView buttonWebViewRefresh;
  private ImageView buttonWebViewShareUrl;
  private ImageView buttonWebViewBack;
  private ImageView buttonWebViewMore;

  private ProgressBar progressBarWebView;

  private WebView webView;

  private String url;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_web_view, Color.WHITE, true);
    initRes();

    url = getIntent().getStringExtra(Const.EXTRA_URL);

    if (url != null) {
      setWebView(url);
      setClickListener();
    } else {
      return false;
    }
    return true;
  }

  @Initializer
  private void initRes() {
    layoutWebViewTitle = findViewById(R.id.chPluginLayoutWebViewTitle);
    textWebViewTitle = findViewById(R.id.chPluginTextWebViewTitle);
    textWebViewUrl = findViewById(R.id.chPluginTextWebViewUrl);
    textWebViewLoading = findViewById(R.id.chPluginTextWebViewLoading);

    filterWebViewPreviousPageButton = findViewById(R.id.chPluginFilterWebViewPreviousPageButton);
    filterWebViewNextPageButton = findViewById(R.id.chPluginFilterWebViewNextPageButton);

    buttonWebViewPreviousPage = findViewById(R.id.chPluginButtonWebViewPreviousPage);
    buttonWebViewNextPage = findViewById(R.id.chPluginButtonWebViewNextPage);
    buttonWebViewRefresh = findViewById(R.id.chPluginButtonWebViewRefresh);
    buttonWebViewShareUrl = findViewById(R.id.chPluginButtonWebViewShareUrl);
    buttonWebViewBack = findViewById(R.id.chPluginButtonWebViewBack);
    buttonWebViewMore = findViewById(R.id.chButtonWebViewMore);

    progressBarWebView = findViewById(R.id.ch_progress_web_view);

    webView = findViewById(R.id.chPluginWebView);
  }

  private void setWebView(String url) {
    textWebViewUrl.setText(url);

    WebSettings settings = webView.getSettings();
    settings.setJavaScriptEnabled(true);
    settings.setLoadWithOverviewMode(true);
    settings.setUseWideViewPort(true);
    settings.setDomStorageEnabled(true);
    settings.setCacheMode(WebSettings.LOAD_NO_CACHE);

    String customUserAgent = settings.getUserAgentString().replace("; wv", "");
    settings.setUserAgentString(customUserAgent);

    webView.loadUrl(url);

    webView.setWebChromeClient(new WebChromeClient() {
      @Override
      public void onProgressChanged(WebView view, int newProgress) {
        progressBarWebView.setProgress(newProgress);
      }

      @Override
      public void onReceivedTitle(WebView view, String title) {
        super.onReceivedTitle(view, title);
      }
    });

    webView.setWebViewClient(new WebViewClient() {

      @Override
      public boolean shouldOverrideUrlLoading(WebView webView, String url) {
        if (UriUtils.isIntentUri(url)) {
          Intent parsedIntent = null;

          try {
            parsedIntent = Intent.parseUri(url, 0);
            startActivity(parsedIntent);
          } catch (Exception exception) {
            return UriUtils.doFallBack(CHWebViewActivity.this, parsedIntent);
          }
        } else if (URLUtil.isNetworkUrl(url)) {
          webView.loadUrl(url);
        } else {
          return false;
        }

        return true;
      }

      @Override
      public void onPageStarted(WebView view, String url, Bitmap favicon) {
        setWebViewVisibility(true);

        textWebViewLoading.setText(TEXT_PAGE_LOADING);
      }

      @Override
      public void onPageFinished(WebView view, String url) {
        setWebViewVisibility(false);

        textWebViewTitle.setText(view.getTitle());
        setWebViewActionButtonState();
      }
    });
  }

  private void setWebViewActionButtonState() {
    filterWebViewPreviousPageButton.setBackgroundColor(webView.canGoBack()
        ? ContextCompat.getColor(this, R.color.ch_charcoal_grey)
        : ContextCompat.getColor(this, R.color.ch_lighter));

    filterWebViewNextPageButton.setBackgroundColor(webView.canGoForward()
        ? ContextCompat.getColor(this, R.color.ch_charcoal_grey)
        : ContextCompat.getColor(this, R.color.ch_lighter));

    buttonWebViewPreviousPage.setClickable(webView.canGoBack());
    buttonWebViewPreviousPage.setEnabled(webView.canGoBack());
    buttonWebViewNextPage.setClickable(webView.canGoForward());
    buttonWebViewNextPage.setEnabled(webView.canGoForward());
  }

  private void setWebViewVisibility(boolean loading) {
    Views.setVisibility(textWebViewLoading, loading);
    Views.setVisibility(layoutWebViewTitle, !loading);
    Views.setVisibility(progressBarWebView, loading);
  }

  private void setClickListener() {
    buttonWebViewBack.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        finish();
      }
    });
    buttonWebViewBack.setOnTouchListener(new ButtonTouchHandler());

    buttonWebViewPreviousPage.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        webView.goBack();
      }
    });
    buttonWebViewPreviousPage.setOnTouchListener(new ButtonTouchHandler());

    buttonWebViewNextPage.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        webView.goForward();
      }
    });
    buttonWebViewNextPage.setOnTouchListener(new ButtonTouchHandler());

    buttonWebViewRefresh.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        webView.reload();
      }
    });
    buttonWebViewRefresh.setOnTouchListener(new ButtonTouchHandler());

    buttonWebViewShareUrl.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        shareUrl(url);
      }
    });
    buttonWebViewShareUrl.setOnTouchListener(new ButtonTouchHandler());

    buttonWebViewMore.setOnClickListener(v -> {
      PopupMenu popupMenu = new PopupMenu(CHWebViewActivity.this, v);
      popupMenu.getMenuInflater().inflate(R.menu.menu_webview_popup, popupMenu.getMenu());
      popupMenu.setOnMenuItemClickListener(this);
      popupMenu.show();
    });
  }

  private void shareUrl(String url) {
    Intent intent = new Intent(Intent.ACTION_SEND);
    intent.setType("text/plain");
    intent.putExtra(Intent.EXTRA_TEXT, url);

    startActivity(Intent.createChooser(intent, "Share"));
  }

  @Override
  public void onBackPressed() {
    if (canGoBack()) {
      webView.goBack();
    } else {
      super.onBackPressed();
    }
  }

  private boolean canGoBack() {
    return webView != null && webView.canGoBack();
  }

  @Override
  public boolean onMenuItemClick(MenuItem item) {
    if (item.getItemId() == R.id.menuButtonExternalBrowser) {
      gotoExternalBrowser();
    } else if (item.getItemId() == R.id.menuButtonCopyLink) {
      ClipboardUtils.copyToClipBoard(url);
    }
    return false;
  }

  private void gotoExternalBrowser() {
    try {
      startActivity(new Intent(Intent.ACTION_VIEW).setData(Uri.parse(url)));
    } catch (Exception exception) {
    }
  }

}
