/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.video_player.AbsVideoPlayerView;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.google.android.exoplayer2.DefaultRenderersFactory;
import com.zoyi.com.google.android.exoplayer2.ExoPlayerFactory;
import com.zoyi.com.google.android.exoplayer2.Player;
import com.zoyi.com.google.android.exoplayer2.RenderersFactory;
import com.zoyi.com.google.android.exoplayer2.SimpleExoPlayer;
import com.zoyi.com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.zoyi.com.google.android.exoplayer2.source.MediaSource;
import com.zoyi.com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelector;
import com.zoyi.com.google.android.exoplayer2.ui.PlayerView;
import com.zoyi.com.google.android.exoplayer2.upstream.DataSource;
import com.zoyi.com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.zoyi.com.google.android.exoplayer2.util.Util;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public class AttachmentVideoPlayerView
extends AbsVideoPlayerView {
    private Context context;
    private PlayerView playerAttachment;
    private View buttonVideoVolumeOn;
    private View buttonVideoVolumeOff;
    private View buttonVideoFullscreen;
    @Nullable
    private SimpleExoPlayer exoPlayer;
    @Nullable
    private Subscription hideControllerSubscription;
    @Nullable
    private Subscription videoProgressSubscription;
    @Nullable
    private File attachment;
    @Nullable
    private OnAttachmentContentActionListener listener;

    public AttachmentVideoPlayerView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public AttachmentVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AttachmentVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.ch_view_attachment_video_player, (ViewGroup)this);
        this.playerAttachment = (PlayerView)this.findViewById(R.id.ch_playerAttachment);
        this.buttonVideoVolumeOn = this.findViewById(R.id.ch_buttonVideoVolumeOn);
        this.buttonVideoVolumeOff = this.findViewById(R.id.ch_buttonVideoVolumeOff);
        this.buttonVideoFullscreen = this.findViewById(R.id.ch_buttonVideoFullscreen);
        this.buttonVideoVolumeOn.setOnClickListener(v -> {
            this.applyVolumeButton(false);
            if (this.listener != null) {
                this.listener.onAttachmentActionClick();
            }
        });
        this.buttonVideoVolumeOff.setOnClickListener(v -> {
            this.applyVolumeButton(true);
            if (this.listener != null) {
                this.listener.onAttachmentActionClick();
            }
        });
        this.buttonVideoFullscreen.setOnClickListener(v -> {
            if (this.exoPlayer != null) {
                this.exoPlayer.setPlayWhenReady(false);
            }
            if (this.listener != null && this.attachment != null) {
                this.listener.onOpenVideoClick(this.attachment, this.getLatestSeconds() * TimeUnit.SECONDS.toMillis(1L));
            }
        });
    }

    public AttachmentVideoPlayerView setUrl(@Nullable String messageId, File attachment, final @Nullable OnAttachmentContentActionListener listener, @Nullable Boolean isVolumeOn) {
        this.setId(String.format("%s:%s", messageId, attachment.getId()));
        this.attachment = attachment;
        this.listener = listener;
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory();
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        boolean volumeState = (Boolean)Optional.ofNullable((Object)isVolumeOn).orElse((Object)this.getLatestVolumeState());
        this.exoPlayer = ExoPlayerFactory.newSimpleInstance((Context)this.context, (RenderersFactory)new DefaultRenderersFactory(this.context), (TrackSelector)trackSelector);
        this.exoPlayer.addListener(new Player.EventListener(){

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                AttachmentVideoPlayerView.this.changeVideoState(playWhenReady);
                if (playWhenReady) {
                    AttachmentVideoPlayerView.this.bindVideoProgress();
                } else {
                    AttachmentVideoPlayerView.this.unbindVideoProgress();
                }
                switch (playbackState) {
                    case 4: {
                        if (AttachmentVideoPlayerView.this.exoPlayer == null) break;
                        AttachmentVideoPlayerView.this.exoPlayer.seekTo(0L);
                        AttachmentVideoPlayerView.this.exoPlayer.setPlayWhenReady(false);
                        break;
                    }
                    default: {
                        if (listener == null) break;
                        listener.onAttachmentActionClick();
                    }
                }
            }
        });
        this.playerAttachment.setPlayer((Player)this.exoPlayer);
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(this.context, Util.getUserAgent((Context)this.context, (String)"ChannelSDK"));
        ExtractorMediaSource videoSource = new ExtractorMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(Uri.parse((String)attachment.getUrl()));
        this.exoPlayer.prepare((MediaSource)videoSource);
        this.exoPlayer.setPlayWhenReady(true);
        this.exoPlayer.seekTo(this.getLatestSeconds() * TimeUnit.SECONDS.toMillis(1L));
        this.applyVolumeButton(volumeState);
        return this;
    }

    private void applyVolumeButton(boolean isVolumeOn) {
        if (this.exoPlayer != null) {
            this.exoPlayer.setVolume(isVolumeOn ? 1.0f : 0.0f);
        }
        Views.setVisibility(this.buttonVideoVolumeOn, isVolumeOn);
        Views.setVisibility(this.buttonVideoVolumeOff, !isVolumeOn);
        this.changeVideoVolumeState(isVolumeOn);
    }

    @Override
    void onVideoPaused() {
        if (this.exoPlayer != null) {
            this.exoPlayer.setPlayWhenReady(false);
        }
    }

    private void bindVideoProgress() {
        if (this.videoProgressSubscription == null || this.videoProgressSubscription.isUnsubscribed()) {
            this.unbindVideoProgress();
            this.videoProgressSubscription = Observable.interval((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS).onBackpressureLatest().subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> Optional.ofNullable((Object)this.exoPlayer).map(SimpleExoPlayer::getCurrentPosition).map(position -> position / TimeUnit.SECONDS.toMillis(1L)).ifPresent(this::changeVideoPosition));
        }
    }

    private void unbindVideoProgress() {
        this.dispose(this.videoProgressSubscription);
    }

    private void dispose(@Nullable Subscription subscription) {
        if (subscription != null && !subscription.isUnsubscribed()) {
            subscription.unsubscribe();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.attachment = null;
        this.listener = null;
        this.dispose(this.hideControllerSubscription);
        this.dispose(this.videoProgressSubscription);
        this.hideControllerSubscription = null;
        this.videoProgressSubscription = null;
        if (this.exoPlayer != null) {
            this.exoPlayer.release();
            this.exoPlayer = null;
        }
    }
}

