/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.util.AttributeSet;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.MarketingAction;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.view.media_thumbnail.FullScreenPopUpMediaThumbnailView;
import com.zoyi.channel.plugin.android.view.popup.BasePushView;
import java.util.Locale;

public class FullScreenPushView
extends BasePushView {
    private TextView textPopUpTime;

    public FullScreenPushView(@NonNull Context context) {
        super(context);
    }

    public FullScreenPushView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public FullScreenPushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.ch_plugin_view_push_full_screen;
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.textPopUpTime = (TextView)this.root.findViewById(R.id.ch_textPopUpTime);
        ((FullScreenPopUpMediaThumbnailView)this.viewPopUpMedia).setOnFullScreenPopUpClickListener(() -> {
            if (this.item != null) {
                MarketingAction.sendClickEvent(this.item.getMarketing());
            }
        });
    }

    @Override
    public void show(Message message) {
        super.show(message);
        MarketingAction.sendViewEvent(message.getMarketing());
    }

    @Override
    protected void bindContent(Message message) {
        super.bindContent(message);
        this.textPopUpTime.setText((CharSequence)TimeUtils.getTime(message.getCreatedAt()));
    }

    @Override
    protected void setMediaSize(Previewable previewable) {
        if (previewable.getHeight() != 0) {
            float maxRatio = 1.7777778f;
            float minRatio = 1.0f;
            float ratio = previewable.getWidth() / previewable.getHeight();
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.viewPopUpMedia.getLayoutParams();
            params.dimensionRatio = ratio < minRatio ? "H,1:1" : (ratio > maxRatio ? "H,16:9" : String.format(Locale.ENGLISH, "H,%d:%d", previewable.getWidth(), previewable.getHeight()));
        }
    }

    @Override
    public void resetView() {
        super.resetView();
    }

    @Override
    protected int getDefaultTextMaxLine() {
        return 8;
    }

    @Override
    protected int getAttachmentTextMaxLine() {
        return 4;
    }
}

