/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;
import java.util.Locale;

public class FormatUtils {
    @Nullable
    public static String formatDuration(@Nullable Long durationMilliseconds) {
        if (durationMilliseconds == null || durationMilliseconds == 0L) {
            return null;
        }
        long durationSeconds = durationMilliseconds / 1000L;
        long hours = durationSeconds / 3600L;
        long minutes = durationSeconds % 3600L / 60L;
        long seconds = durationSeconds % 60L;
        if (hours > 0L) {
            return String.format(Locale.ENGLISH, "%d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format(Locale.ENGLISH, "%d:%02d", minutes, seconds);
    }

    public static String formatFileSize(long bytes) {
        if (bytes < 1000L) {
            return String.format(Locale.US, "%dB", bytes);
        }
        if (bytes <= 1000000L) {
            return String.format(Locale.US, "%.1fKB", (double)bytes / 1000.0);
        }
        if (bytes <= 1000000000L) {
            return String.format(Locale.US, "%.1fMB", (double)bytes / 1000000.0);
        }
        return String.format(Locale.US, "%.1fGB", (double)bytes / 1.0E9);
    }
}

