/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.photo_picker.OnPhotoClickListener;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoHolder;
import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerAdapterContract;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.draw.Display;
import java.util.ArrayList;

class PhotoPickerAdapter
extends RecyclerView.Adapter<PhotoHolder>
implements PhotoPickerAdapterContract.View,
PhotoPickerAdapterContract.Model {
    private Context context;
    @Nullable
    private OnPhotoClickListener listener;
    private ArrayList<PhotoItem> photoItems;
    private ArrayList<PhotoItem> selectedPaths;
    private int itemSize;
    private int itemMargin;

    PhotoPickerAdapter(Context context) {
        this.context = context;
        this.photoItems = new ArrayList();
        this.selectedPaths = new ArrayList();
        this.itemSize = Display.getWidth(context) / 3;
        this.itemMargin = (int)Utils.dpToPx(context, 2.0f);
    }

    @Override
    public void setOnPhotoClickListener(OnPhotoClickListener listener) {
        this.listener = listener;
    }

    public PhotoHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new PhotoHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.ch_plugin_item_photo_picker, parent, false), this.itemSize, this.itemMargin, this.listener);
    }

    public void onBindViewHolder(PhotoHolder holder, int position) {
        PhotoItem photoItem = this.photoItems.get(position);
        holder.setValue(photoItem, position, this.isExists(photoItem));
    }

    public int getItemCount() {
        return this.photoItems.size();
    }

    @Override
    public void setPhotoItems(ArrayList<PhotoItem> photoItems) {
        this.photoItems = photoItems;
        this.notifyDataSetChanged();
    }

    @Override
    public boolean onPhotoItemClick(PhotoItem photoItem) {
        Uri uri = photoItem.getUri();
        int selectedIndex = this.getSelectedIndex(photoItem);
        if (uri != null) {
            if (selectedIndex >= 0) {
                this.selectedPaths.remove(selectedIndex);
                this.updatePhotoItem(photoItem);
            } else if (this.selectedPaths.size() < 20) {
                this.selectedPaths.add(photoItem);
                this.updatePhotoItem(photoItem);
            } else {
                return false;
            }
        }
        return true;
    }

    private int getSelectedIndex(PhotoItem photoItem) {
        for (int i = 0; i < this.selectedPaths.size(); ++i) {
            if (this.selectedPaths.get(i).getId() != photoItem.getId()) continue;
            return i;
        }
        return -1;
    }

    private boolean isExists(PhotoItem photoItem) {
        return this.getSelectedIndex(photoItem) >= 0;
    }

    private void updatePhotoItem(PhotoItem photoItem) {
        for (int i = 0; i < this.photoItems.size(); ++i) {
            if (this.photoItems.get(i).getId() != photoItem.getId()) continue;
            this.notifyItemChanged(i);
            break;
        }
    }

    @Override
    public ArrayList<PhotoItem> getSelectedItems() {
        return this.selectedPaths;
    }
}

