/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store.UserChatStore;

public class UserChatAction {
    public static void fetchUserChats(boolean showClosedChats) {
        UserChatStore.get().userChatsFetchState.set(FetchState.LOADING);
        Api.getUserChats("updatedAt", "DESC", 50, showClosedChats).runBy(ActionType.REQUEST_USER_CHATS).cancelBy(ActionType.REQUEST_LOUNGE, ActionType.SOCKET_DISCONNECTED, ActionType.MESSENGER_CLOSED, ActionType.SHUTDOWN).run(new RestSubscriber<UserChatsWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                UserChatStore.get().userChatsFetchState.set(FetchState.FAILED);
            }

            @Override
            public void onSuccess(@NonNull UserChatsWrapper userChatsWrapper) {
                userChatsWrapper.set();
            }
        });
    }

    public static void fetchUserChats(boolean showClosedChats, String next) {
        UserChatStore.get().userChatsFetchState.set(FetchState.LOADING);
        Api.getUserChats("updatedAt", "DESC", 50, showClosedChats, next).runBy(ActionType.REQUEST_USER_CHATS_CONTINUOUS).cancelBy(ActionType.REQUEST_LOUNGE, ActionType.REQUEST_USER_CHATS, ActionType.SOCKET_DISCONNECTED, ActionType.MESSENGER_CLOSED, ActionType.SHUTDOWN).run(new RestSubscriber<UserChatsWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                UserChatStore.get().userChatsFetchState.set(FetchState.FAILED);
            }

            @Override
            public void onSuccess(@NonNull UserChatsWrapper userChatsWrapper) {
                userChatsWrapper.add();
            }
        });
    }
}

