/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.User;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.wrapper.UserWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.open.callback.TagUpdateCallback;
import com.zoyi.channel.plugin.android.open.exception.ChannelException;
import java.util.List;

public class TagAction {
    public static void addTags(@Nullable List<String> tags, final @Nullable TagUpdateCallback callback) {
        Api.addTags(tags).cancelBy(ActionType.SHUTDOWN).run(new RestSubscriber<UserWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                if (callback != null) {
                    callback.callback(ChannelException.newInstance(error.getMessage()), null);
                }
            }

            @Override
            public void onSuccess(@NonNull UserWrapper repo) {
                if (callback != null) {
                    callback.callback(null, User.newInstance(repo.getUser()));
                }
            }
        });
    }

    public static void removeTags(@Nullable List<String> tags, final @Nullable TagUpdateCallback callback) {
        Api.removeTags(tags).cancelBy(ActionType.SHUTDOWN).run(new RestSubscriber<UserWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                if (callback != null) {
                    callback.callback(ChannelException.newInstance(error.getMessage()), null);
                }
            }

            @Override
            public void onSuccess(@NonNull UserWrapper repo) {
                if (callback != null) {
                    callback.callback(null, User.newInstance(repo.getUser()));
                }
            }
        });
    }
}

