/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.location.Location;
import android.text.TextUtils;
import com.splunk.mint.ExtraData;
import com.splunk.mint.Properties;
import com.splunk.mint.Utils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

abstract class BaseDTO {
    protected static final String UNKNOWN = "NA";
    protected byte type;
    protected String sessionID;
    protected HashMap<String, Object> customData;
    private Long msFromStart;
    protected Long timestampMilis;
    private static volatile String globalSessionID = Utils.getRandomSessionNumber();
    private static volatile Boolean globalIsInitialSession = true;

    protected static synchronized String getGlobalSessionID() {
        return globalSessionID;
    }

    protected static synchronized void resetGlobalSessionID() {
        if (globalIsInitialSession.booleanValue()) {
            globalIsInitialSession = false;
            return;
        }
        globalSessionID = Utils.getRandomSessionNumber();
    }

    public BaseDTO(byte dataType, HashMap<String, Object> customData_) {
        this(dataType, customData_, null);
    }

    public BaseDTO(byte dataType, HashMap<String, Object> customData_, String sessionID) {
        this.sessionID = TextUtils.isEmpty((CharSequence)sessionID) ? BaseDTO.getGlobalSessionID() : sessionID;
        this.timestampMilis = System.currentTimeMillis();
        this.type = dataType;
        this.customData = customData_;
        this.msFromStart = Utils.getMilisFromStart();
    }

    public synchronized void resetSessionID() {
        BaseDTO.resetGlobalSessionID();
        this.sessionID = BaseDTO.getGlobalSessionID();
    }

    public synchronized JSONObject getBasicDataFixtureJson() {
        JSONObject json = new JSONObject();
        try {
            json.put("sdkVersion", (Object)"5.2.1");
            json.put("apiKey", (Object)Properties.API_KEY);
            json.put("platform", (Object)"Android");
            json.put("device", (Object)((Properties.PHONE_BRAND != null ? Properties.PHONE_BRAND + " " : "") + Properties.PHONE_MODEL));
            json.put("osVersion", (Object)Properties.OS_VERSION);
            json.put("locale", (Object)Properties.LOCALE);
            json.put("uuid", (Object)Properties.UID);
            json.put("userIdentifier", (Object)Properties.userIdentifier);
            json.put("appEnvironment", (Object)Properties.applicationEnvironment);
            json.put("batteryLevel", Properties.BATTERY_LEVEL);
            json.put("carrier", (Object)Properties.CARRIER);
            json.put("remoteIP", (Object)"{%#@@#%}");
            json.put("appVersionCode", (Object)Properties.APP_VERSIONCODE);
            json.put("appVersionName", (Object)Properties.APP_VERSIONNAME);
            json.put("packageName", (Object)Properties.APP_PACKAGE);
            json.put("connection", (Object)Properties.CONNECTION);
            json.put("state", (Object)Properties.STATE);
            json.put("currentView", (Object)Properties.lastView);
            json.put("screenOrientation", (Object)Properties.SCREEN_ORIENTATION);
            json.put("msFromStart", (Object)this.msFromStart);
            json.put("session_id", (Object)this.sessionID);
            JSONObject extraDataJson = new JSONObject();
            ExtraData extraData = Properties.extraData;
            if (extraData != null && !extraData.isEmpty()) {
                for (Map.Entry entry : extraData.entrySet()) {
                    if (entry.getValue() == null) {
                        extraDataJson.put((String)entry.getKey(), (Object)"null");
                        continue;
                    }
                    extraDataJson.put((String)entry.getKey(), entry.getValue());
                }
            }
            if (this.customData != null && !this.customData.isEmpty()) {
                for (Map.Entry<Object, Object> entry : this.customData.entrySet()) {
                    if (entry.getValue() == null) {
                        extraDataJson.put((String)entry.getKey(), (Object)"null");
                        continue;
                    }
                    extraDataJson.put((String)entry.getKey(), entry.getValue());
                }
            }
            json.put("extraData", (Object)extraDataJson);
            if (Properties.startedTransactions != null) {
                json.put("transactions", (Object)Properties.startedTransactions.getTransactionsJson());
            }
            this.addLocation(json);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    void addLocation(JSONObject json) {
        JSONObject jsonLocation = new JSONObject();
        String longitude = UNKNOWN;
        String latitude = UNKNOWN;
        String timestamp = UNKNOWN;
        Location location = Properties.location;
        if (location != null) {
            longitude = Double.toString(location.getLongitude());
            latitude = Double.toString(location.getLatitude());
            timestamp = Long.toString(location.getTime());
        }
        try {
            jsonLocation.put("longitude", (Object)longitude);
            jsonLocation.put("latitude", (Object)latitude);
            jsonLocation.put("timestamp", (Object)timestamp);
            json.put("location", (Object)jsonLocation);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

