/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subscriptions;

import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeSubscription
implements Subscription {
    private Set<Subscription> subscriptions;
    private volatile boolean unsubscribed;

    public CompositeSubscription() {
    }

    public CompositeSubscription(Subscription ... subscriptions) {
        this.subscriptions = new HashSet<Subscription>(Arrays.asList(subscriptions));
    }

    @Override
    public boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Subscription s) {
        if (s.isUnsubscribed()) {
            return;
        }
        if (!this.unsubscribed) {
            CompositeSubscription compositeSubscription = this;
            synchronized (compositeSubscription) {
                if (!this.unsubscribed) {
                    if (this.subscriptions == null) {
                        this.subscriptions = new HashSet<Subscription>(4);
                    }
                    this.subscriptions.add(s);
                    return;
                }
            }
        }
        s.unsubscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Subscription ... subscriptions) {
        if (!this.unsubscribed) {
            CompositeSubscription object = this;
            synchronized (object) {
                if (!this.unsubscribed) {
                    if (this.subscriptions == null) {
                        this.subscriptions = new HashSet<Subscription>(subscriptions.length);
                    }
                    for (Subscription s : subscriptions) {
                        if (s.isUnsubscribed()) continue;
                        this.subscriptions.add(s);
                    }
                    return;
                }
            }
        }
        for (Subscription s : subscriptions) {
            s.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Subscription s) {
        if (!this.unsubscribed) {
            boolean unsubscribe;
            CompositeSubscription compositeSubscription = this;
            synchronized (compositeSubscription) {
                if (this.unsubscribed || this.subscriptions == null) {
                    return;
                }
                unsubscribe = this.subscriptions.remove(s);
            }
            if (unsubscribe) {
                s.unsubscribe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!this.unsubscribed) {
            Set<Subscription> unsubscribe;
            CompositeSubscription compositeSubscription = this;
            synchronized (compositeSubscription) {
                if (this.unsubscribed || this.subscriptions == null) {
                    return;
                }
                unsubscribe = this.subscriptions;
                this.subscriptions = null;
            }
            CompositeSubscription.unsubscribeFromAll(unsubscribe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe() {
        if (!this.unsubscribed) {
            Set<Subscription> unsubscribe;
            CompositeSubscription compositeSubscription = this;
            synchronized (compositeSubscription) {
                if (this.unsubscribed) {
                    return;
                }
                this.unsubscribed = true;
                unsubscribe = this.subscriptions;
                this.subscriptions = null;
            }
            CompositeSubscription.unsubscribeFromAll(unsubscribe);
        }
    }

    private static void unsubscribeFromAll(Collection<Subscription> subscriptions) {
        if (subscriptions == null) {
            return;
        }
        ArrayList<Throwable> es = null;
        for (Subscription s : subscriptions) {
            try {
                s.unsubscribe();
            }
            catch (Throwable e) {
                if (es == null) {
                    es = new ArrayList<Throwable>();
                }
                es.add(e);
            }
        }
        Exceptions.throwIfAny(es);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscriptions() {
        if (!this.unsubscribed) {
            CompositeSubscription compositeSubscription = this;
            synchronized (compositeSubscription) {
                return !this.unsubscribed && this.subscriptions != null && !this.subscriptions.isEmpty();
            }
        }
        return false;
    }
}

