package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;

import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerAdapterContract;
import com.zoyi.channel.plugin.android.activity.photo_picker.contract.PhotoPickerContract;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoDataSource;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoRepository;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.rx.Subscriber;

import java.util.ArrayList;

public class PhotoPickerPresenter
    extends AbstractAdapterPresenter<PhotoPickerContract.View, PhotoPickerAdapterContract.View, PhotoPickerAdapterContract.Model>
    implements PhotoPickerContract.Presenter, OnPhotoClickListener {

  private Context context;

  private PhotoRepository photoRepository;

  @Initializer
  PhotoPickerPresenter(
      Context context,
      PhotoPickerContract.View view,
      PhotoPickerAdapterContract.View adapterView,
      PhotoPickerAdapterContract.Model adapterModel
  ) {
    super(view, adapterView, adapterModel);

    adapterView.setOnPhotoClickListener(this);
    this.context = context;
  }

  @Initializer
  @Override
  public void init() {
    photoRepository = new PhotoRepository(new PhotoDataSource());
  }

  @Override
  public void fetchPhotoItems() {
    photoRepository.getPhotoItems(context, new Subscriber<ArrayList<PhotoItem>>() {
      @Override
      public void onCompleted() {
      }

      @Override
      public void onError(Throwable throwable) {
        view.loadPhotoItems(new ArrayList<>());
      }

      @Override
      public void onNext(ArrayList<PhotoItem> photoItems) {
        view.loadPhotoItems(photoItems);

        adapterModel.setPhotoItems(photoItems);

        view.onSelectChange(adapterModel.getSelectedItems().size());
      }
    });
  }

  @Override
  public void onPhotoClick(PhotoItem photoItem) {
    if (!adapterView.onPhotoItemClick(photoItem)) {
      view.showLimitPopup();
    }
    view.onSelectChange(adapterModel.getSelectedItems().size());
  }

  @Override
  public ArrayList<PhotoItem> getSelectedItems() {
    return adapterModel.getSelectedItems();
  }
}
