package com.zoyi.channel.plugin.android.view.youtube.ui;

import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.view.View;

import com.zoyi.channel.plugin.android.view.youtube.ui.menu.YouTubePlayerMenu;

public interface PlayerUiController {

  PlayerUiController showUi(boolean show);

  PlayerUiController showPlayPauseButton(boolean show);

  PlayerUiController showVideoTitle(boolean show);

  PlayerUiController setVideoTitle(String videoTitle);

  PlayerUiController enableLiveVideoUi(boolean enable);

  /**
   * Set custom action to the left of the Play/Pause button
   */
  PlayerUiController setCustomAction1(Drawable icon, @Nullable View.OnClickListener clickListener);

  /**
   * Set custom action to the right of the Play/Pause button
   */
  PlayerUiController setCustomAction2(Drawable icon, @Nullable View.OnClickListener clickListener);

  PlayerUiController showCustomAction1(boolean show);

  PlayerUiController showCustomAction2(boolean show);

  PlayerUiController showFullscreenButton(boolean show);

  PlayerUiController setFullScreenButtonClickListener(View.OnClickListener customFullScreenButtonClickListener);

  PlayerUiController showMenuButton(boolean show);

  PlayerUiController setMenuButtonClickListener(View.OnClickListener customMenuButtonClickListener);

  PlayerUiController showCurrentTime(boolean show);

  PlayerUiController showDuration(boolean show);

  PlayerUiController showSeekBar(boolean show);

  PlayerUiController showBufferingProgress(boolean show);

  PlayerUiController showYouTubeButton(boolean show);

  /**
   * Adds a View to the top of the player
   *
   * @param view View to be added
   */
  PlayerUiController addView(View view);

  /**
   * Removes a View added with [PlayerUiController.addView]
   *
   * @param view View to be removed
   */
  PlayerUiController removeView(View view);

  @Nullable
  YouTubePlayerMenu getMenu();
}
