package com.zoyi.channel.plugin.android.activity.chat.manager;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.activity.chat.listener.MessageSendListener;
import com.zoyi.rx.Observable;

import java.util.List;

public interface ChatManagerInterface {

  void attachListener(@Nullable MessageSendListener listener);

  void clearListener();

  void sendMessage(SendItem item);

  void sendMessages(List<SendItem> items);

  void resend(SendItem item);

  void remove(SendItem item);

  void cancelRecentSendingFile();

  int getWaitingFileCount();

  int getCurrentFileUploadProgress();

  @NonNull
  List<SendItem> getUnsentItems();

  Observable<Integer> getUploadProgressObservable();

  Observable<Integer> getWaitingCountObservable();

  void release();
}
