/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.youtube.player.util;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.AbstractYouTubePlayerListener;
import com.zoyi.channel.plugin.android.view.youtube.player.util.YouTubePlayerUtils;

public class PlaybackResumer
extends AbstractYouTubePlayerListener {
    private boolean canLoad = false;
    private boolean isPlaying = false;
    @Nullable
    private PlayerConstants.PlayerError error;
    @Nullable
    private String currentVideoId;
    private float currentSecond = 0.0f;

    public void resume(YouTubePlayer youTubePlayer) {
        if (this.isPlaying && this.error == PlayerConstants.PlayerError.HTML_5_PLAYER) {
            YouTubePlayerUtils.loadOrCueVideo(youTubePlayer, this.canLoad, this.currentVideoId, this.currentSecond);
        } else if (!this.isPlaying && this.error == PlayerConstants.PlayerError.HTML_5_PLAYER) {
            youTubePlayer.cueVideo(this.currentVideoId, this.currentSecond);
        }
        this.error = null;
    }

    @Override
    public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
        switch (state) {
            case ENDED: 
            case PAUSED: {
                this.isPlaying = false;
                return;
            }
            case PLAYING: {
                this.isPlaying = true;
                return;
            }
        }
    }

    @Override
    public void onError(YouTubePlayer youTubePlayer, PlayerConstants.PlayerError error) {
        if (error == PlayerConstants.PlayerError.HTML_5_PLAYER) {
            this.error = error;
        }
    }

    @Override
    public void onCurrentSecond(YouTubePlayer youTubePlayer, float second) {
        this.currentSecond = second;
    }

    @Override
    public void onVideoId(YouTubePlayer youTubePlayer, String videoId) {
        this.currentVideoId = videoId;
    }

    public void onLifecycleResume() {
        this.canLoad = true;
    }

    public void onLifecycleStop() {
        this.canLoad = false;
    }
}

